/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.Block;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.corelib.components.Delegate;
import org.apache.tapestry5.corelib.components.Loop;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.StringToEnumCoercion;
import org.chenillekit.tapestry.core.components.Pager;
import org.chenillekit.tapestry.core.internal.PagedSource;
import org.chenillekit.tapestry.core.internal.PagerPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedLoop
implements ClientElement {
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(value="prop:componentResources.elementName", defaultPrefix="literal")
    private String element;
    @Parameter(required=true)
    private Iterable<?> source;
    private PagedSource<?> pagedSource;
    @Parameter(value="bottom", defaultPrefix="literal")
    private String pagerPosition;
    private PagerPosition internalPagerPosition;
    @Parameter(value="25")
    private int rowsPerPage;
    @Persist
    private int currentPage;
    @Parameter
    private Object value;
    @Parameter(name="volatile")
    private boolean isVolatile;
    @Parameter
    private int index;
    @Parameter(required=true)
    private ValueEncoder encoder;
    @Component(parameters={"source=pagedSource", "element=prop:element", "value=inherit:value", "volatile=inherit:volatile", "encoder=inherit:encoder", "index=inherit:index"})
    private Loop loop;
    @Component(parameters={"source=pagedSource", "rowsPerPage=rowsPerPage", "currentPage=currentPage"})
    private Pager internalPager;
    @Component(parameters={"to=pagerTop"})
    private Delegate pagerTop;
    @Component(parameters={"to=pagerBottom"})
    private Delegate pagerBottom;
    @Parameter(value="block:empty")
    private Block empty;
    @Inject
    private ComponentResources resources;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    private String assignedClientId;

    public String getElement() {
        return this.element;
    }

    public Object getPagerTop() {
        return this.internalPagerPosition.isMatchTop() ? this.internalPager : null;
    }

    public Object getPagerBottom() {
        return this.internalPagerPosition.isMatchBottom() ? this.internalPager : null;
    }

    public PagedSource<?> getPagedSource() {
        return this.pagedSource;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    Object setupRender() {
        if (this.currentPage == 0) {
            this.currentPage = 1;
        }
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
        this.internalPagerPosition = (PagerPosition)new StringToEnumCoercion(PagerPosition.class).coerce(this.pagerPosition);
        this.pagedSource = new PagedSource(this.source);
        int availableRows = this.pagedSource.getTotalRowCount();
        if (availableRows == 0) {
            return this.empty;
        }
        int startIndex = (this.currentPage - 1) * this.rowsPerPage;
        int endIndex = Math.min(startIndex + this.rowsPerPage - 1, availableRows - 1);
        this.pagedSource.prepare(startIndex, endIndex);
        return null;
    }

    @BeginRender
    Object begin() {
        return this.pagedSource.getTotalRowCount() != 0;
    }

    void onAction(int newPage) {
        this.currentPage = newPage;
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

