/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.chenillekit.google.services.GoogleGeoCoder;

@SupportsInformalParameters
@Import(library={"../Chenillekit.js", "GPlotter.js"})
public class GPlotter
implements ClientElement {
    @Inject
    private ComponentResources resources;
    @Inject
    private Request request;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private GoogleGeoCoder geoCoder;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(defaultPrefix="prop")
    private Double lat;
    @Parameter(defaultPrefix="prop")
    private Double lng;
    @Parameter(defaultPrefix="literal", value="")
    private String errorCallbackFunction;
    @Parameter(defaultPrefix="literal", value="")
    private String dragendCallbackFunction;
    private String assignedClientId;

    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    public String getPlotterId() {
        return this.getClientId();
    }

    void beginRender(MarkupWriter writer) {
        Element root = writer.getDocument().getRootElement();
        Element head = root.find("head");
        head.element("script", new String[]{"src", "http://maps.google.com/maps?file=api&v=2&key=" + this.geoCoder.getKey() + "&hl=" + this.request.getLocale().getLanguage(), "type", "text/javascript", "id", "gmap"});
        writer.element("div", new Object[]{"id", this.getClientId() + "_map"});
        this.resources.renderInformalParameters(writer);
        writer.end();
    }

    void afterRender() {
        JSONObject configuration = new JSONObject();
        configuration.put("zoomLevel", (Object)13);
        configuration.put("smallControl", (Object)true);
        configuration.put("largeControl", (Object)false);
        configuration.put("typeControl", (Object)true);
        configuration.put("label", (Object)"location");
        this.configure(configuration);
        this.javascriptSupport.addScript("var %s = new Ck.GPlotter('%s_map', '%s', '%s', '%s', %s);", new Object[]{this.getClientId(), this.getClientId(), this.geoCoder.getKey(), this.errorCallbackFunction, this.dragendCallbackFunction, configuration.toString()});
        this.javascriptSupport.addScript("%s.setCenter(%s, %s);", new Object[]{this.getClientId(), this.lat, this.lng});
    }

    protected void configure(JSONObject jsonObject) {
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

