/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateSelector
extends AbstractField {
    @Parameter(required=true, defaultPrefix="prop")
    private Date value;
    @Parameter(defaultPrefix="prop", value="1970")
    private int firstYear;
    @Parameter(defaultPrefix="prop", value="2030")
    private int lastYear;
    @Parameter(defaultPrefix="prop", value="false")
    private boolean longMonth;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Property
    @Persist
    private int dayValue;
    @Property
    @Persist
    private int monthValue;
    @Property
    @Persist
    private int yearValue;
    @Inject
    private Locale locale;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private Request request;
    @Inject
    private ComponentResources resources;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    private List<Integer> days = CollectionFactory.newList();
    private List<Integer> months = CollectionFactory.newList();
    private List<Integer> years = CollectionFactory.newList();
    private Calendar calendar = Calendar.getInstance(this.locale);

    final Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    void setupRender() {
        if (this.value == null) {
            this.value = new Date();
        }
        this.calendar.setTime(this.value);
        this.dayValue = this.calendar.get(5);
        this.monthValue = this.calendar.get(2);
        this.yearValue = this.calendar.get(1);
    }

    void beginRender(MarkupWriter writer) {
        Element element;
        writer.element("span", new Object[]{"class", "ck-dateselector", "id", this.getClientId()});
        writer.element("select", new Object[]{"class", "day", "id", this.getClientId() + "_day", "name", this.getControlName() + "_day"});
        for (int day = 1; day < 32; ++day) {
            element = writer.element("option", new Object[]{"value", day});
            if (this.dayValue == day) {
                element.attribute("selected", "selected");
            }
            writer.write(String.format("%02d", day));
            writer.end();
        }
        writer.end();
        writer.element("select", new Object[]{"class", "month", "id", this.getClientId() + "_month", "name", this.getControlName() + "_month"});
        for (int month = 0; month < 12; ++month) {
            element = writer.element("option", new Object[]{"value", month});
            if (this.monthValue == month) {
                element.attribute("selected", "selected");
            }
            writer.write(String.format("%02d", month + 1));
            writer.end();
        }
        writer.end();
        writer.element("select", new Object[]{"class", "year", "id", this.getClientId() + "_year", "name", this.getControlName() + "_year"});
        for (int year = this.firstYear; year <= this.lastYear; ++year) {
            element = writer.element("option", new Object[]{"value", year});
            if (this.yearValue == year) {
                element.attribute("selected", "selected");
            }
            writer.write(String.format("%d", year));
            writer.end();
        }
        writer.end();
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public List<Integer> getDaySelectModel() {
        return this.days;
    }

    public List<Integer> getMonthSelectModel() {
        return this.months;
    }

    public List<Integer> getYearSelectModel() {
        return this.years;
    }

    protected void processSubmission(String elementName) {
        String rawDayValue = this.request.getParameter(elementName + "_day");
        String rawMonthValue = this.request.getParameter(elementName + "_month");
        String rawYearValue = this.request.getParameter(elementName + "_year");
        try {
            this.calendar.set(Integer.parseInt(rawYearValue), Integer.parseInt(rawMonthValue), Integer.parseInt(rawDayValue));
            this.calendar.setLenient(false);
            Date translated = this.calendar.getTime();
            this.fieldValidationSupport.validate((Object)translated, this.resources, this.validate);
            this.value = translated;
        }
        catch (ValidationException ex) {
            this.tracker.recordError((Field)this, ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            this.tracker.recordError((Field)this, ex.getMessage());
        }
    }
}

