/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.image.services.impl;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import org.apache.tapestry5.ioc.Resource;
import org.chenillekit.image.services.ImageService;

public class ImageServiceImpl
implements ImageService {
    private Image toAwtImage(Resource imageResource) {
        Image image = Toolkit.getDefaultToolkit().getImage(imageResource.toURL());
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return image;
    }

    public void reduceImageQuality(BufferedImage image, float quality, OutputStream output) {
        ImageWriter encoder = ImageIO.getImageWritersByFormatName("JPEG").next();
        JPEGImageWriteParam param = new JPEGImageWriteParam(null);
        quality = Math.max(0.0f, Math.min(quality, 100.0f));
        param.setCompressionMode(2);
        param.setCompressionQuality(quality / 100.0f);
        encoder.setOutput(output);
        try {
            encoder.write(null, new IIOImage(image, null, null), param);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedImage scaleImage(Resource imageResource, int height) {
        Image image = this.toAwtImage(imageResource);
        double imageRatio = (double)image.getWidth(null) / (double)image.getHeight(null);
        int thumbWidth = (int)((double)height * imageRatio);
        BufferedImage thumbImage = new BufferedImage(thumbWidth, height, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, height, null);
        return thumbImage;
    }
}

