/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.aruco;

import org.opencv.aruco.Board;
import org.opencv.aruco.Dictionary;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Size;

public class CharucoBoard
extends Board {
    protected CharucoBoard(long addr) {
        super(addr);
    }

    public static CharucoBoard __fromPtr__(long addr) {
        return new CharucoBoard(addr);
    }

    public static CharucoBoard create(int squaresX, int squaresY, float squareLength, float markerLength, Dictionary dictionary) {
        CharucoBoard retVal = CharucoBoard.__fromPtr__(CharucoBoard.create_0(squaresX, squaresY, squareLength, markerLength, dictionary.getNativeObjAddr()));
        return retVal;
    }

    public Size getChessboardSize() {
        Size retVal = new Size(CharucoBoard.getChessboardSize_0(this.nativeObj));
        return retVal;
    }

    public float getMarkerLength() {
        float retVal = CharucoBoard.getMarkerLength_0(this.nativeObj);
        return retVal;
    }

    public float getSquareLength() {
        float retVal = CharucoBoard.getSquareLength_0(this.nativeObj);
        return retVal;
    }

    public void draw(Size outSize, Mat img, int marginSize, int borderBits) {
        CharucoBoard.draw_0(this.nativeObj, outSize.width, outSize.height, img.nativeObj, marginSize, borderBits);
    }

    public void draw(Size outSize, Mat img) {
        CharucoBoard.draw_1(this.nativeObj, outSize.width, outSize.height, img.nativeObj);
    }

    public MatOfPoint3f get_chessboardCorners() {
        MatOfPoint3f retVal = MatOfPoint3f.fromNativeAddr(CharucoBoard.get_chessboardCorners_0(this.nativeObj));
        return retVal;
    }

    @Override
    protected void finalize() throws Throwable {
        CharucoBoard.delete(this.nativeObj);
    }

    private static native long create_0(int var0, int var1, float var2, float var3, long var4);

    private static native double[] getChessboardSize_0(long var0);

    private static native float getMarkerLength_0(long var0);

    private static native float getSquareLength_0(long var0);

    private static native void draw_0(long var0, double var2, double var4, long var6, int var8, int var9);

    private static native void draw_1(long var0, double var2, double var4, long var6);

    private static native long get_chessboardCorners_0(long var0);

    private static native void delete(long var0);
}

