/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.normalized;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import java.util.Arrays;

public class ConvolveNormalizedNaive_IL {
    public static void horizontal(Kernel1D_F32 kernel, InterleavedF32 input, InterleavedF32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        float[] pixel = new float[numBands];
        float[] total = new float[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0.0f);
                float weight = 0.0f;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    float v = kernel.get(j - x + offset);
                    input.get(j, y, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                int band = 0;
                while (band < numBands) {
                    int n = band++;
                    total[n] = total[n] / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, InterleavedF32 input, InterleavedF32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        float[] pixel = new float[numBands];
        float[] total = new float[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0.0f);
                float weight = 0.0f;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    float v = kernel.get(i - y + offset);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                int band = 0;
                while (band < numBands) {
                    int n = band++;
                    total[n] = total[n] / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, InterleavedF32 input, InterleavedF32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        float[] pixel = new float[numBands];
        float[] total = new float[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                Arrays.fill(total, 0.0f);
                float weight = 0.0f;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        input.get(j, i, pixel);
                        float v = kernel.get(j - x + offset, i - y + offset);
                        for (int band = 0; band < numBands; ++band) {
                            int n = band;
                            total[n] = total[n] + pixel[band] * v;
                        }
                        weight += v;
                    }
                }
                int band = 0;
                while (band < numBands) {
                    int n = band++;
                    total[n] = total[n] / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void horizontal(Kernel1D_F64 kernel, InterleavedF64 input, InterleavedF64 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        double[] pixel = new double[numBands];
        double[] total = new double[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0.0);
                double weight = 0.0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    double v = kernel.get(j - x + offset);
                    input.get(j, y, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                int band = 0;
                while (band < numBands) {
                    int n = band++;
                    total[n] = total[n] / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_F64 kernel, InterleavedF64 input, InterleavedF64 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        double[] pixel = new double[numBands];
        double[] total = new double[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0.0);
                double weight = 0.0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    double v = kernel.get(i - y + offset);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                int band = 0;
                while (band < numBands) {
                    int n = band++;
                    total[n] = total[n] / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(Kernel2D_F64 kernel, InterleavedF64 input, InterleavedF64 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        double[] pixel = new double[numBands];
        double[] total = new double[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                Arrays.fill(total, 0.0);
                double weight = 0.0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        input.get(j, i, pixel);
                        double v = kernel.get(j - x + offset, i - y + offset);
                        for (int band = 0; band < numBands; ++band) {
                            int n = band;
                            total[n] = total[n] + pixel[band] * v;
                        }
                        weight += v;
                    }
                }
                int band = 0;
                while (band < numBands) {
                    int n = band++;
                    total[n] = total[n] / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedU8 input, InterleavedI8 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    int v = kernel.get(j - x + offset);
                    input.get(j, y, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedU8 input, InterleavedI8 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernel.get(i - y + offset);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedU8 input, InterleavedI8 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        input.get(j, i, pixel);
                        int v = kernel.get(j - x + offset, i - y + offset);
                        for (int band = 0; band < numBands; ++band) {
                            int n = band;
                            total[n] = total[n] + pixel[band] * v;
                        }
                        weight += v;
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedS16 input, InterleavedI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    int v = kernel.get(j - x + offset);
                    input.get(j, y, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedS16 input, InterleavedI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernel.get(i - y + offset);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedS16 input, InterleavedI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        input.get(j, i, pixel);
                        int v = kernel.get(j - x + offset, i - y + offset);
                        for (int band = 0; band < numBands; ++band) {
                            int n = band;
                            total[n] = total[n] + pixel[band] * v;
                        }
                        weight += v;
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedU16 input, InterleavedI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    int v = kernel.get(j - x + offset);
                    input.get(j, y, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedU16 input, InterleavedI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernel.get(i - y + offset);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedU16 input, InterleavedI16 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        input.get(j, i, pixel);
                        int v = kernel.get(j - x + offset, i - y + offset);
                        for (int band = 0; band < numBands; ++band) {
                            int n = band;
                            total[n] = total[n] + pixel[band] * v;
                        }
                        weight += v;
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedS32 input, InterleavedS32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                for (int j = startX; j < endX; ++j) {
                    int v = kernel.get(j - x + offset);
                    input.get(j, y, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedS32 input, InterleavedS32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weight = 0;
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernel.get(i - y + offset);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weight += v;
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedS32 input, InterleavedS32 output) {
        int offset = kernel.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int startX = x - offset;
                int endX = startX + kernel.getWidth();
                if (startX < 0) {
                    startX = 0;
                }
                if (endX > width) {
                    endX = width;
                }
                int startY = y - offset;
                int endY = startY + kernel.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                Arrays.fill(total, 0);
                int weight = 0;
                for (int i = startY; i < endY; ++i) {
                    for (int j = startX; j < endX; ++j) {
                        input.get(j, i, pixel);
                        int v = kernel.get(j - x + offset, i - y + offset);
                        for (int band = 0; band < numBands; ++band) {
                            int n = band;
                            total[n] = total[n] + pixel[band] * v;
                        }
                        weight += v;
                    }
                }
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernelX, Kernel1D_S32 kernelY, InterleavedU16 input, InterleavedI8 output) {
        int offsetX = kernelX.getOffset();
        int offsetY = kernelY.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weightY = 0;
                int startY = y - offsetY;
                int endY = startY + kernelY.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernelY.get(i - y + offsetY);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weightY += v;
                }
                int kerX0 = Math.max(0, offsetX - x);
                int kerX1 = Math.min(kernelX.getWidth(), width - x + offsetX);
                int weightX = 0;
                for (int i = kerX0; i < kerX1; ++i) {
                    weightX += kernelX.get(i);
                }
                int weight = weightX * weightY;
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernelX, Kernel1D_S32 kernelY, InterleavedS32 input, InterleavedI16 output) {
        int offsetX = kernelX.getOffset();
        int offsetY = kernelY.getOffset();
        int width = input.getWidth();
        int height = input.getHeight();
        int numBands = input.getNumBands();
        int[] pixel = new int[numBands];
        int[] total = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Arrays.fill(total, 0);
                int weightY = 0;
                int startY = y - offsetY;
                int endY = startY + kernelY.getWidth();
                if (startY < 0) {
                    startY = 0;
                }
                if (endY > height) {
                    endY = height;
                }
                for (int i = startY; i < endY; ++i) {
                    int v = kernelY.get(i - y + offsetY);
                    input.get(x, i, pixel);
                    for (int band = 0; band < numBands; ++band) {
                        int n = band;
                        total[n] = total[n] + pixel[band] * v;
                    }
                    weightY += v;
                }
                int kerX0 = Math.max(0, offsetX - x);
                int kerX1 = Math.min(kernelX.getWidth(), width - x + offsetX);
                int weightX = 0;
                for (int i = kerX0; i < kerX1; ++i) {
                    weightX += kernelX.get(i);
                }
                int weight = weightX * weightY;
                for (int band = 0; band < numBands; ++band) {
                    total[band] = (total[band] + weight / 2) / weight;
                }
                output.set(x, y, total);
            }
        }
    }
}

