/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.denoise.wavelet;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import org.ddogleg.sorting.QuickSelect;
import org.jetbrains.annotations.Nullable;

public class UtilDenoiseWavelet {
    public static float estimateNoiseStdDev(GrayF32 subband, @Nullable float[] storage) {
        storage = UtilDenoiseWavelet.subbandAbsVal(subband, storage);
        int N = subband.width * subband.height;
        return QuickSelect.select((float[])storage, (int)(N / 2), (int)N) / 0.6745f;
    }

    public static float[] subbandAbsVal(GrayF32 subband, @Nullable float[] coef) {
        if (coef == null) {
            coef = new float[subband.width * subband.height];
        }
        int i = 0;
        for (int y = 0; y < subband.height; ++y) {
            int index;
            int end = index + subband.width;
            for (index = subband.startIndex + subband.stride * y; index < end; ++index) {
                coef[i++] = Math.abs(subband.data[index]);
            }
        }
        return coef;
    }

    public static double universalThreshold(ImageGray image, double noiseSigma) {
        int w = image.width;
        int h = image.height;
        return noiseSigma * Math.sqrt(2.0 * Math.log(Math.max(w, h)));
    }
}

