/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ImplColorRgb_MT {
    public static void rgbToGray_Weighted_U8(Planar<GrayU8> rgb, GrayU8 gray) {
        GrayU8 R = (GrayU8)rgb.getBand(0);
        GrayU8 G = (GrayU8)rgb.getBand(1);
        GrayU8 B = (GrayU8)rgb.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)rgb.height, row -> {
            int indexRgb;
            int indedGra = gray.startIndex + row * gray.stride;
            int end = indexRgb + rgb.width;
            for (indexRgb = rgb.startIndex + row * rgb.stride; indexRgb < end; ++indexRgb) {
                int r = R.data[indexRgb] & 0xFF;
                int g = G.data[indexRgb] & 0xFF;
                int b = B.data[indexRgb] & 0xFF;
                gray.data[indedGra++] = (byte)((299 * r + 587 * g + 114 * b) / 1000);
            }
        });
    }

    public static void rgbToGray_Weighted_F32(Planar<GrayF32> rgb, GrayF32 gray) {
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)rgb.height, row -> {
            int indexRgb;
            int indedGra = gray.startIndex + row * gray.stride;
            int end = indexRgb + rgb.width;
            for (indexRgb = rgb.startIndex + row * rgb.stride; indexRgb < end; ++indexRgb) {
                float r = R.data[indexRgb];
                float g = G.data[indexRgb];
                float b = B.data[indexRgb];
                gray.data[indedGra++] = 0.299f * r + 0.587f * g + 0.114f * b;
            }
        });
    }

    public static void rgbToGray_Weighted_F64(Planar<GrayF64> rgb, GrayF64 gray) {
        GrayF64 R = (GrayF64)rgb.getBand(0);
        GrayF64 G = (GrayF64)rgb.getBand(1);
        GrayF64 B = (GrayF64)rgb.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)rgb.height, row -> {
            int indexRgb;
            int indedGra = gray.startIndex + row * gray.stride;
            int end = indexRgb + rgb.width;
            for (indexRgb = rgb.startIndex + row * rgb.stride; indexRgb < end; ++indexRgb) {
                double r = R.data[indexRgb];
                double g = G.data[indexRgb];
                double b = B.data[indexRgb];
                gray.data[indedGra++] = 0.299 * r + 0.587 * g + 0.114 * b;
            }
        });
    }

    public static void rgbToGray_Weighted(InterleavedU8 rgb, GrayU8 gray) {
        BoofConcurrency.loopFor((int)0, (int)rgb.height, row -> {
            int indedGra;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int end = indedGra + rgb.width;
            for (indedGra = gray.startIndex + row * gray.stride; indedGra < end; ++indedGra) {
                int r = rgb.data[indexRgb++] & 0xFF;
                int g = rgb.data[indexRgb++] & 0xFF;
                int b = rgb.data[indexRgb++] & 0xFF;
                gray.data[indedGra] = (byte)((299 * r + 587 * g + 114 * b) / 1000);
            }
        });
    }

    public static void rgbToGray_Weighted(InterleavedF32 rgb, GrayF32 gray) {
        BoofConcurrency.loopFor((int)0, (int)rgb.height, row -> {
            int indedGra;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int end = indedGra + rgb.width;
            for (indedGra = gray.startIndex + row * gray.stride; indedGra < end; ++indedGra) {
                float r = rgb.data[indexRgb++];
                float g = rgb.data[indexRgb++];
                float b = rgb.data[indexRgb++];
                gray.data[indedGra] = 0.299f * r + 0.587f * g + 0.114f * b;
            }
        });
    }

    public static void rgbToGray_Weighted(InterleavedF64 rgb, GrayF64 gray) {
        BoofConcurrency.loopFor((int)0, (int)rgb.height, row -> {
            int indedGra;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int end = indedGra + rgb.width;
            for (indedGra = gray.startIndex + row * gray.stride; indedGra < end; ++indedGra) {
                double r = rgb.data[indexRgb++];
                double g = rgb.data[indexRgb++];
                double b = rgb.data[indexRgb++];
                gray.data[indedGra] = 0.299 * r + 0.587 * g + 0.114 * b;
            }
        });
    }
}

