/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.log.log4j2.message;

import net.sf.log4jdbc.log.log4j2.message.SqlMessage;
import net.sf.log4jdbc.sql.Spy;
import org.apache.logging.log4j.message.Message;

public class ExceptionOccuredMessage
extends SqlMessage
implements Message {
    private static final long serialVersionUID = 4033892630843448750L;
    private Spy spy;
    private String methodCall;
    private long execTime;
    private String sql;

    public ExceptionOccuredMessage() {
        this(null, null, null, -1L, false);
    }

    public ExceptionOccuredMessage(Spy spy, String methodCall, String sql, long execTime, boolean isdebugEnabled) {
        super(isdebugEnabled);
        this.spy = spy;
        this.methodCall = methodCall;
        this.sql = sql;
        this.execTime = execTime;
    }

    protected void buildMessage() {
        String tempMessage = "";
        String classType = this.spy.getClassType();
        Integer spyNo = this.spy.getConnectionNumber();
        String header = spyNo + ". " + classType + "." + this.methodCall;
        if (this.sql == null) {
            tempMessage = header;
        } else {
            String tempSql = this.processSql(this.sql);
            tempMessage = this.isDebugEnabled() ? SqlMessage.getDebugInfo() + SqlMessage.nl + spyNo + ". " + tempSql : header + " FAILED! " + tempSql;
            if (this.execTime != -1L) {
                tempMessage = tempMessage + " {FAILED after " + this.execTime + " ms}";
            }
        }
        this.setMessage(tempMessage);
    }
}

