/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.log.SpyLogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Properties {
    private static volatile SpyLogDelegator log = null;
    static final String SpyLogDelegatorName;
    static final String DebugStackPrefix;
    static final boolean TraceFromApplication;
    static final boolean SqlTimingWarnThresholdEnabled;
    static final long SqlTimingWarnThresholdMsec;
    static final boolean SqlTimingErrorThresholdEnabled;
    static final long SqlTimingErrorThresholdMsec;
    static final boolean DumpBooleanAsTrueFalse;
    static final int DumpSqlMaxLineLength;
    static final boolean StatementUsageWarn;
    static final boolean DumpSqlSelect;
    static final boolean DumpSqlInsert;
    static final boolean DumpSqlUpdate;
    static final boolean DumpSqlDelete;
    static final boolean DumpSqlCreate;
    static final boolean DumpSqlFilteringOn;
    static final boolean DumpSqlAddSemicolon;
    static final boolean DumpFullDebugStackTrace;
    static final boolean AutoLoadPopularDrivers;
    static final Collection<String> AdditionalDrivers;
    static final boolean TrimSql;
    static final boolean TrimExtraBlankLinesInSql;
    static final boolean SuppressGetGeneratedKeysException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static java.util.Properties getProperties() {
        InputStream propStream;
        java.util.Properties props = new java.util.Properties(System.getProperties());
        String propertyFile = props.getProperty("log4jdbc.log4j2.properties.file", "/log4jdbc.log4j2.properties");
        if (log != null) {
            log.debug("Trying to use properties file " + propertyFile);
        }
        if ((propStream = Properties.class.getResourceAsStream(propertyFile)) != null) {
            try {
                props.load(propStream);
            }
            catch (IOException e) {
                if (log != null) {
                    log.debug("Error when loading log4jdbc.log4j2.properties from classpath: " + e.getMessage());
                }
            }
            finally {
                block18: {
                    try {
                        propStream.close();
                    }
                    catch (IOException e) {
                        if (log == null) break block18;
                        log.debug("Error when closing log4jdbc.log4j2.properties file" + e.getMessage());
                    }
                }
            }
            if (log != null) {
                log.debug("log4jdbc.logj2.properties loaded from classpath");
            }
        } else if (log != null) {
            log.debug("log4jdbc.logj2.properties not found in classpath. Using System properties.");
        }
        return props;
    }

    private static Long getLongOption(java.util.Properties props, String propName) {
        String propValue = props.getProperty(propName);
        Long longPropValue = null;
        if (propValue == null) {
            log.debug("x " + propName + " is not defined");
        } else {
            try {
                longPropValue = new Long(Long.parseLong(propValue));
                log.debug("  " + propName + " = " + longPropValue);
            }
            catch (NumberFormatException n) {
                log.debug("x " + propName + " \"" + propValue + "\" is not a valid number");
            }
        }
        return longPropValue;
    }

    private static Long getLongOption(java.util.Properties props, String propName, long defaultValue) {
        Long longPropValue;
        String propValue = props.getProperty(propName);
        if (propValue == null) {
            log.debug("x " + propName + " is not defined (using default of " + defaultValue + ")");
            longPropValue = new Long(defaultValue);
        } else {
            try {
                longPropValue = new Long(Long.parseLong(propValue));
                log.debug("  " + propName + " = " + longPropValue);
            }
            catch (NumberFormatException n) {
                log.debug("x " + propName + " \"" + propValue + "\" is not a valid number (using default of " + defaultValue + ")");
                longPropValue = new Long(defaultValue);
            }
        }
        return longPropValue;
    }

    private static String getStringOption(java.util.Properties props, String propName) {
        String propValue = props.getProperty(propName);
        if (propValue == null || propValue.length() == 0) {
            log.debug("x " + propName + " is not defined");
            propValue = null;
        } else {
            log.debug("  " + propName + " = " + propValue);
        }
        return propValue;
    }

    private static boolean getBooleanOption(java.util.Properties props, String propName, boolean defaultValue) {
        String propValue = props.getProperty(propName);
        if (propValue == null) {
            log.debug("x " + propName + " is not defined (using default value " + defaultValue + ")");
            return defaultValue;
        }
        boolean val = (propValue = propValue.trim().toLowerCase()).length() == 0 ? defaultValue : "true".equals(propValue) || "yes".equals(propValue) || "on".equals(propValue);
        log.debug("  " + propName + " = " + val);
        return val;
    }

    public static String getSpyLogDelegatorName() {
        return SpyLogDelegatorName;
    }

    public static boolean isSqlTrim() {
        return TrimSql;
    }

    public static int getDumpSqlMaxLineLength() {
        return DumpSqlMaxLineLength;
    }

    public static boolean isDumpSqlAddSemicolon() {
        return DumpSqlAddSemicolon;
    }

    public static boolean isTrimExtraBlankLinesInSql() {
        return TrimExtraBlankLinesInSql;
    }

    public static boolean isDumpFullDebugStackTrace() {
        return DumpFullDebugStackTrace;
    }

    public static boolean isTraceFromApplication() {
        return TraceFromApplication;
    }

    public static String getDebugStackPrefix() {
        return DebugStackPrefix;
    }

    public static boolean isDumpSqlFilteringOn() {
        return DumpSqlFilteringOn;
    }

    public static boolean isDumpSqlSelect() {
        return DumpSqlSelect;
    }

    public static boolean isDumpSqlUpdate() {
        return DumpSqlUpdate;
    }

    public static boolean isDumpSqlInsert() {
        return DumpSqlInsert;
    }

    public static boolean isDumpSqlDelete() {
        return DumpSqlDelete;
    }

    public static boolean isDumpSqlCreate() {
        return DumpSqlCreate;
    }

    public static boolean isSqlTimingErrorThresholdEnabled() {
        return SqlTimingErrorThresholdEnabled;
    }

    public static long getSqlTimingErrorThresholdMsec() {
        return SqlTimingErrorThresholdMsec;
    }

    public static boolean isSqlTimingWarnThresholdEnabled() {
        return SqlTimingWarnThresholdEnabled;
    }

    public static long getSqlTimingWarnThresholdMsec() {
        return SqlTimingWarnThresholdMsec;
    }

    public static boolean isAutoLoadPopularDrivers() {
        return AutoLoadPopularDrivers;
    }

    public static Collection<String> getAdditionalDrivers() {
        return AdditionalDrivers;
    }

    public static boolean isDumpBooleanAsTrueFalse() {
        return DumpBooleanAsTrueFalse;
    }

    public static boolean isStatementUsageWarn() {
        return StatementUsageWarn;
    }

    public static boolean isSuppressGetGeneratedKeysException() {
        return SuppressGetGeneratedKeysException;
    }

    static {
        java.util.Properties props = Properties.getProperties();
        SpyLogDelegatorName = props.getProperty("log4jdbc.spylogdelegator.name");
        SpyLogFactory.loadSpyLogDelegator(Properties.getSpyLogDelegatorName());
        log = SpyLogFactory.getSpyLogDelegator();
        log.debug("log4jdbc-logj2 properties initialization...");
        log.debug("Using logger: " + Properties.getSpyLogDelegatorName());
        DebugStackPrefix = Properties.getStringOption(props, "log4jdbc.debug.stack.prefix");
        TraceFromApplication = DebugStackPrefix != null;
        Long thresh = Properties.getLongOption(props, "log4jdbc.sqltiming.warn.threshold");
        SqlTimingWarnThresholdEnabled = thresh != null;
        long SqlTimingWarnThresholdMsecTemp = -1L;
        if (SqlTimingWarnThresholdEnabled) {
            SqlTimingWarnThresholdMsecTemp = thresh;
        }
        SqlTimingWarnThresholdMsec = SqlTimingWarnThresholdMsecTemp;
        thresh = Properties.getLongOption(props, "log4jdbc.sqltiming.error.threshold");
        SqlTimingErrorThresholdEnabled = thresh != null;
        long SqlTimingErrorThresholdMsecTemp = -1L;
        if (SqlTimingErrorThresholdEnabled) {
            SqlTimingErrorThresholdMsecTemp = thresh;
        }
        SqlTimingErrorThresholdMsec = SqlTimingErrorThresholdMsecTemp;
        DumpBooleanAsTrueFalse = Properties.getBooleanOption(props, "log4jdbc.dump.booleanastruefalse", false);
        DumpSqlMaxLineLength = Properties.getLongOption(props, "log4jdbc.dump.sql.maxlinelength", 90L).intValue();
        DumpFullDebugStackTrace = Properties.getBooleanOption(props, "log4jdbc.dump.fulldebugstacktrace", false);
        StatementUsageWarn = Properties.getBooleanOption(props, "log4jdbc.statement.warn", false);
        DumpSqlSelect = Properties.getBooleanOption(props, "log4jdbc.dump.sql.select", true);
        DumpSqlInsert = Properties.getBooleanOption(props, "log4jdbc.dump.sql.insert", true);
        DumpSqlUpdate = Properties.getBooleanOption(props, "log4jdbc.dump.sql.update", true);
        DumpSqlDelete = Properties.getBooleanOption(props, "log4jdbc.dump.sql.delete", true);
        DumpSqlCreate = Properties.getBooleanOption(props, "log4jdbc.dump.sql.create", true);
        DumpSqlFilteringOn = !DumpSqlSelect || !DumpSqlInsert || !DumpSqlUpdate || !DumpSqlDelete || !DumpSqlCreate;
        DumpSqlAddSemicolon = Properties.getBooleanOption(props, "log4jdbc.dump.sql.addsemicolon", false);
        AutoLoadPopularDrivers = Properties.getBooleanOption(props, "log4jdbc.auto.load.popular.drivers", true);
        String moreDrivers = Properties.getStringOption(props, "log4jdbc.drivers");
        AdditionalDrivers = new HashSet<String>();
        if (moreDrivers != null) {
            String[] moreDriversArr = moreDrivers.split(",");
            for (int i = 0; i < moreDriversArr.length; ++i) {
                AdditionalDrivers.add(moreDriversArr[i]);
                log.debug("    will look for specific driver " + moreDriversArr[i]);
            }
        }
        TrimSql = Properties.getBooleanOption(props, "log4jdbc.trim.sql", true);
        TrimExtraBlankLinesInSql = Properties.getBooleanOption(props, "log4jdbc.trim.sql.extrablanklines", true);
        SuppressGetGeneratedKeysException = Properties.getBooleanOption(props, "log4jdbc.suppress.generated.keys.exception", false);
        log.debug("log4jdbc-logj2 properties initialization done.");
    }
}

