/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.ant;

import java.awt.image.BufferedImage;
import junit.framework.Test;
import org.assertj.core.util.Strings;
import org.assertj.swing.image.ScreenshotTaker;
import org.assertj.swing.junit.ant.GUITestRecognizer;
import org.assertj.swing.junit.ant.ImageHandler;
import org.assertj.swing.junit.ant.Tests;
import org.assertj.swing.junit.xml.XmlAttribute;
import org.assertj.swing.junit.xml.XmlNode;

class ScreenshotXmlWriter {
    private static final String SCREENSHOT_ELEMENT = "screenshot";
    private static final String SCREENSHOT_FILE_ATTRIBUTE = "file";
    private final ScreenshotTaker screenshotTaker;
    private final GUITestRecognizer guiTestRecognizer;

    ScreenshotXmlWriter() {
        this(new ScreenshotTaker(), new GUITestRecognizer());
    }

    ScreenshotXmlWriter(ScreenshotTaker screenshotTaker, GUITestRecognizer guiTestRecognizer) {
        this.screenshotTaker = screenshotTaker;
        this.guiTestRecognizer = guiTestRecognizer;
    }

    void writeScreenshot(XmlNode target, Test test) {
        String testMethod;
        String testClass = Tests.testClassNameFrom(test);
        if (!this.guiTestRecognizer.isGUITest(testClass, testMethod = Tests.testMethodNameFrom(test))) {
            return;
        }
        String image = this.takeScreenshotAndReturnEncoded();
        if (Strings.isEmpty((String)image)) {
            return;
        }
        this.writeScreenshotFileName(target, image, this.imageFileName(testClass, testMethod));
    }

    private String takeScreenshotAndReturnEncoded() {
        BufferedImage image = this.screenshotTaker.takeDesktopScreenshot();
        return ImageHandler.encodeBase64(image);
    }

    private void writeScreenshotFileName(XmlNode target, String encodedImage, String imageFileName) {
        XmlNode screenshotNode = target.parentNode().addNewNode(SCREENSHOT_ELEMENT);
        screenshotNode.addAttribute(XmlAttribute.name(SCREENSHOT_FILE_ATTRIBUTE).value(imageFileName));
        screenshotNode.addText(encodedImage);
    }

    private String imageFileName(String testClass, String testMethod) {
        return Strings.join((String[])new String[]{testClass, testMethod, "png"}).with(".");
    }
}

