/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Attributes {
    private static final char ATTRIBUTE_SEPARATOR = '=';
    private static Format DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static Format TIME_FORMAT = new SimpleDateFormat("HH:mm:ss z");
    public static final String BACKEND = "backend";
    public static final String TITLE = "title";
    public static final String DOCTYPE = "doctype";
    public static final String IMAGESDIR = "imagesdir";
    public static final String SOURCE_HIGHLIGHTER = "source-highlighter";
    public static final String LOCALDATE = "localdate";
    public static final String LOCALTIME = "localtime";
    public static final String DOCDATE = "docdate";
    public static final String DOCTIME = "doctime";
    public static final String TOC = "toc";
    public static final String STYLESHEET_NAME = "stylesheet";
    public static final String STYLES_DIR = "stylesdir";
    public static final String NOT_STYLESHEET_NAME = "stylesheet!";
    public static final String LINK_CSS = "linkcss";
    public static final String COPY_CSS = "copycss";
    public static final String ICONS = "icons";
    public static final String ICONS_DIR = "iconsdir";
    public static final String DATA_URI = "data-uri";
    public static final String SECTION_NUMBERS = "numbered";
    public static final String ORIGINAL_ADMONITION_ICONS_WITH_IMG = "";
    public static final String FONTAWESOME_ADMONITION_ICONS = "font";
    public static final String LINK_ATTRS = "linkattrs";
    public static final String EXPERIMENTAL = "experimental";
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public Attributes() {
    }

    public Attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setBackend(String backend) {
        this.attributes.put(BACKEND, backend);
    }

    public void setTitle(String title) {
        this.attributes.put(TITLE, title);
    }

    public void setDocType(String docType) {
        this.attributes.put(DOCTYPE, docType);
    }

    public void setImagesDir(String imagesDir) {
        this.attributes.put(IMAGESDIR, imagesDir);
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.attributes.put(SOURCE_HIGHLIGHTER, sourceHighlighter);
    }

    public void setTableOfContents(boolean toc) {
        this.attributes.put(TOC, Attributes.toAsciidoctorFlag(toc));
    }

    public void setLocalDate(Date localDate) {
        this.attributes.put(LOCALDATE, Attributes.toDate(localDate));
    }

    public void setLocalTime(Date localTime) {
        this.attributes.put(LOCALTIME, Attributes.toTime(localTime));
    }

    public void setDocDate(Date docDate) {
        this.attributes.put(DOCDATE, Attributes.toDate(docDate));
    }

    public void setDocTime(Date docTime) {
        this.attributes.put(DOCTIME, Attributes.toTime(docTime));
    }

    public void setStyleSheetName(String styleSheetName) {
        this.attributes.put(STYLESHEET_NAME, styleSheetName);
    }

    public void unsetStyleSheet() {
        this.attributes.put(NOT_STYLESHEET_NAME, Attributes.toAsciidoctorFlag(true));
    }

    public void setStylesDir(String stylesDir) {
        this.attributes.put(STYLES_DIR, stylesDir);
    }

    public void setLinkCss(boolean linkCss) {
        this.attributes.put(LINK_CSS, Attributes.toAsciidoctorFlag(linkCss));
    }

    public void setCopyCss(boolean copyCss) {
        this.attributes.put(COPY_CSS, Attributes.toAsciidoctorFlag(copyCss));
    }

    public void setIcons(String iconsName) {
        this.attributes.put(ICONS, iconsName);
    }

    public void setDataUri(boolean dataUri) {
        this.attributes.put(DATA_URI, Attributes.toAsciidoctorFlag(dataUri));
    }

    public void setIconsDir(String iconsDir) {
        this.attributes.put(ICONS_DIR, iconsDir);
    }

    public void setSectionNumbers(boolean sectionNumbers) {
        this.attributes.put(SECTION_NUMBERS, Attributes.toAsciidoctorFlag(sectionNumbers));
    }

    public void setLinkAttrs(boolean linkAttrs) {
        this.attributes.put(LINK_ATTRS, Attributes.toAsciidoctorFlag(linkAttrs));
    }

    public void setExperimental(boolean experimental) {
        this.attributes.put(EXPERIMENTAL, experimental);
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void setAttributes(String attributes) {
        String[] allAttributes = attributes.split(" ");
        this.addAttributes(allAttributes);
    }

    public void setAttributes(String ... attributes) {
        this.addAttributes(attributes);
    }

    private void addAttributes(String[] allAttributes) {
        for (String attribute : allAttributes) {
            int equalsIndex = -1;
            equalsIndex = attribute.indexOf(61);
            if (equalsIndex > -1) {
                this.extractAttributeNameAndValue(attribute, equalsIndex);
                continue;
            }
            this.attributes.put(attribute, ORIGINAL_ADMONITION_ICONS_WITH_IMG);
        }
    }

    private void extractAttributeNameAndValue(String attribute, int equalsIndex) {
        String attributeName = attribute.substring(0, equalsIndex);
        String attributeValue = attribute.substring(equalsIndex + 1, attribute.length());
        this.attributes.put(attributeName, attributeValue);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public Map<String, Object> map() {
        return this.attributes;
    }

    public static String toAsciidoctorFlag(boolean flag) {
        return flag ? ORIGINAL_ADMONITION_ICONS_WITH_IMG : null;
    }

    private static String toDate(Date date) {
        return DATE_FORMAT.format(date);
    }

    private static String toTime(Date time) {
        return TIME_FORMAT.format(time);
    }
}

