/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.xbean.osgi.bundle.util;

import org.osgi.framework.Bundle;

/**
 * ClassLoader for a {@link Bundle}. 
 * <br/>
 * This ClassLoader implementation extends the {@link BundleClassLoader} and returns resources embedded
 * in jar files in a bundle with <tt>jar</tt> URLs. 
 * 
 * @version $Rev: 1163514 $ $Date: 2011-08-31 00:37:38 -0700 (Wed, 31 Aug 2011) $
 */
public class BundleResourceClassLoader extends BundleClassLoader {

    public BundleResourceClassLoader(Bundle bundle) {
        super(bundle, 
              BundleResourceHelper.getSearchWiredBundles(true), 
              BundleResourceHelper.getConvertResourceUrls(true));
    }

    @Override
    public String toString() {
        return "[BundleResourceClassLoader] " + bundle;
    }
   
}
