/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.kerberos;

import java.security.Principal;
import java.security.PrivilegedAction;
import org.apache.wss4j.common.kerberos.KerberosClientExceptionAction;
import org.apache.wss4j.common.kerberos.KerberosContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosClientAction
implements PrivilegedAction<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosClientAction.class);
    private Principal clientPrincipal;
    private String serviceName;
    private boolean isUsernameServiceNameForm;

    public KerberosClientAction(Principal clientPrincipal, String serviceName) {
        this(clientPrincipal, serviceName, false);
    }

    public KerberosClientAction(Principal clientPrincipal, String serviceName, boolean isUsernameServiceNameForm) {
        this.clientPrincipal = clientPrincipal;
        this.serviceName = serviceName;
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    @Override
    public byte[] run() {
        try {
            KerberosContext krbCtx = new KerberosClientExceptionAction(this.clientPrincipal, this.serviceName, this.isUsernameServiceNameForm).run();
            return krbCtx.getKerberosToken();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error in obtaining a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }
}

