/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.traverse;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;

public class OMChildrenQNameIterator
extends OMChildrenIterator {
    private QName givenQName;
    private boolean needToMoveForward = true;
    private boolean isMatchingNodeFound = false;

    public OMChildrenQNameIterator(OMNode currentChild, QName givenQName) {
        super(currentChild);
        this.givenQName = givenQName;
    }

    public boolean hasNext() {
        while (this.needToMoveForward) {
            if (this.currentChild != null) {
                if (this.currentChild instanceof OMElement && this.isQNamesMatch(((OMElement)this.currentChild).getQName(), this.givenQName)) {
                    this.isMatchingNodeFound = true;
                    this.needToMoveForward = false;
                    continue;
                }
                this.currentChild = this.currentChild.getNextOMSibling();
                this.needToMoveForward = this.currentChild != null;
                this.isMatchingNodeFound = this.needToMoveForward;
                continue;
            }
            this.needToMoveForward = false;
        }
        return this.isMatchingNodeFound;
    }

    public Object next() {
        this.needToMoveForward = true;
        this.isMatchingNodeFound = false;
        this.nextCalled = true;
        this.removeCalled = false;
        this.lastChild = this.currentChild;
        this.currentChild = this.currentChild.getNextOMSibling();
        return this.lastChild;
    }

    private boolean isQNamesMatch(QName elementQName, QName qNameToBeMatched) {
        if (qNameToBeMatched == null) {
            return true;
        }
        String localPart = qNameToBeMatched.getLocalPart();
        boolean localNameMatch = localPart == null || localPart.equals("") || elementQName != null && elementQName.getLocalPart().equalsIgnoreCase(localPart);
        String namespaceURI = qNameToBeMatched.getNamespaceURI();
        boolean namespaceURIMatch = namespaceURI == null || namespaceURI.equals("") || elementQName != null && elementQName.getNamespaceURI().equalsIgnoreCase(namespaceURI);
        return localNameMatch && namespaceURIMatch;
    }
}

