/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat6;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Embedded;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.tomcat.maven.common.config.AbstractWebapp;
import org.apache.tomcat.maven.common.run.EmbeddedRegistry;
import org.apache.tomcat.maven.plugin.tomcat6.AbstractI18NTomcat6Mojo;
import org.apache.tomcat.maven.plugin.tomcat6.ExternalRepositoriesReloadableWebappLoader;
import org.apache.tomcat.maven.plugin.tomcat6.Webapp;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunMojo
extends AbstractI18NTomcat6Mojo {
    @Component(role=ArtifactFactory.class)
    protected ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository artifactRepository;
    @Component(role=ArtifactResolver.class)
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    private String packaging;
    @Parameter(defaultValue="${project.build.directory}/tomcat")
    private File configurationDir;
    @Parameter(property="maven.tomcat.port", defaultValue="8080")
    private int port;
    @Parameter(property="maven.tomcat.address")
    private String address;
    @Parameter(property="maven.tomcat.ajp.port", defaultValue="0")
    private int ajpPort;
    @Parameter(property="maven.tomcat.ajp.protocol", defaultValue="ajp")
    private String ajpProtocol;
    @Parameter(property="maven.tomcat.httpsPort", defaultValue="0")
    private int httpsPort;
    @Parameter(property="maven.tomcat.uriEncoding", defaultValue="ISO-8859-1")
    private String uriEncoding;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter(property="maven.tomcat.additionalConfigFilesDir", defaultValue="${basedir}/src/main/tomcatconf")
    private File additionalConfigFilesDir;
    @Parameter(property="maven.tomcat.serverXml")
    private File serverXml;
    @Parameter(property="maven.tomcat.webXml")
    private File tomcatWebXml;
    @Parameter(property="maven.tomcat.fork", defaultValue="false")
    private boolean fork;
    @Parameter(property="maven.tomcat.addContextWarDependencies", defaultValue="false")
    private boolean addContextWarDependencies;
    @Component
    protected MavenProject project;
    @Component(role=ArchiverManager.class)
    private ArchiverManager archiverManager;
    @Parameter(property="tomcat.useSeparateTomcatClassLoader", defaultValue="false")
    protected boolean useSeparateTomcatClassLoader;
    @Parameter(defaultValue="${plugin.artifacts}", required=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(property="tomcat.ignorePackaging", defaultValue="false")
    private boolean ignorePackaging;
    @Parameter
    private String keystoreFile;
    @Parameter
    private String keystorePass;
    @Parameter(defaultValue="JKS")
    private String keystoreType;
    @Parameter
    private String truststoreFile;
    @Parameter
    private String truststorePass;
    @Parameter
    private String truststoreType;
    @Parameter
    private String truststoreProvider;
    @Parameter(property="maven.tomcat.useNaming", defaultValue="true")
    private boolean useNaming;
    @Parameter(property="maven.tomcat.contextReloadable", defaultValue="false")
    protected boolean contextReloadable;
    @Parameter(property="maven.tomcat.backgroundProcessorDelay", defaultValue="-1")
    protected int backgroundProcessorDelay = -1;
    @Parameter(defaultValue="src/main/webapp/META-INF/context.xml")
    protected File contextFile;
    @Parameter(property="maven.tomcat.protocol", defaultValue="HTTP/1.1")
    private String protocol;
    @Parameter(property="maven.tomcat.tomcatUsers.file")
    private File tomcatUsers;
    @Parameter
    private File managerWarPath;
    @Parameter(property="maven.tomcat.skip", defaultValue="false")
    protected boolean skip;
    @Parameter
    private List<Webapp> webapps;
    @Parameter(property="maven.tomcat.hostName", defaultValue="localhost")
    protected String hostName;
    @Parameter
    protected String[] aliases;
    private ClassRealm tomcatRealm;
    @Parameter(property="maven.tomcat.staticContextPath", defaultValue="/")
    private String staticContextPath;
    @Parameter(property="maven.tomcat.staticContextDocbase")
    private String staticContextDocbase;
    @Parameter
    protected String classLoaderClass;
    @Parameter(property="maven.tomcat.useBodyEncodingForURI", defaultValue="false")
    protected boolean useBodyEncodingForURI;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component(role=MavenFileFilter.class, hint="default")
    protected MavenFileFilter mavenFileFilter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skip execution");
            return;
        }
        if (!this.isWar() && !this.addContextWarDependencies && this.getAdditionalWebapps().isEmpty()) {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.nonWar"));
            return;
        }
        ClassLoader originalClassLoader = null;
        try {
            if (this.useSeparateTomcatClassLoader) {
                originalClassLoader = Thread.currentThread().getContextClassLoader();
            }
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.runningWar", new Object[]{this.getWebappUrl()}));
            this.initConfiguration();
            this.startContainer();
            if (!this.fork) {
                this.waitIndefinitely();
            }
        }
        catch (LifecycleException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractRunMojo.cannotStart"), (Exception)((Object)exception));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractRunMojo.cannotCreateConfiguration"), (Exception)exception);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("filtering issue: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (this.useSeparateTomcatClassLoader) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    @Override
    protected String getPath() {
        return this.path;
    }

    protected Context createContext(Embedded container) throws IOException, MojoExecutionException {
        String contextPath = this.getPath();
        Context context = container.createContext("/".equals(contextPath) ? "" : contextPath, this.getDocBase().getAbsolutePath());
        if (this.useSeparateTomcatClassLoader) {
            context.setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
        }
        WebappLoader webappLoader = this.createWebappLoader();
        if (this.classLoaderClass != null) {
            webappLoader.setLoaderClass(this.classLoaderClass);
        }
        context.setLoader((Loader)webappLoader);
        File contextFile = this.getContextFile();
        if (contextFile != null) {
            context.setConfigFile(this.getContextFile().getAbsolutePath());
        }
        return context;
    }

    protected WebappLoader createWebappLoader() throws IOException, MojoExecutionException {
        if (this.useSeparateTomcatClassLoader) {
            return this.isContextReloadable() ? new ExternalRepositoriesReloadableWebappLoader((ClassLoader)this.getTomcatClassLoader(), this.getLog()) : new WebappLoader((ClassLoader)this.getTomcatClassLoader());
        }
        return this.isContextReloadable() ? new ExternalRepositoriesReloadableWebappLoader(Thread.currentThread().getContextClassLoader(), this.getLog()) : new WebappLoader(Thread.currentThread().getContextClassLoader());
    }

    protected boolean isContextReloadable() throws MojoExecutionException {
        if (this.contextReloadable || this.backgroundProcessorDelay > 0) {
            return true;
        }
        boolean reloadable = false;
        try {
            if (this.contextFile != null && this.contextFile.exists()) {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document contextDoc = builder.parse(this.contextFile);
                contextDoc.getDocumentElement().normalize();
                NamedNodeMap nodeMap = contextDoc.getDocumentElement().getAttributes();
                Node reloadableAttribute = nodeMap.getNamedItem("reloadable");
                reloadable = reloadableAttribute != null ? Boolean.valueOf(reloadableAttribute.getNodeValue()) : false;
            }
            this.getLog().debug((CharSequence)("context reloadable: " + reloadable));
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("Could not parse file: [" + this.contextFile.getAbsolutePath() + "]"), (Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            this.getLog().error((CharSequence)"Could not configure XML parser", (Throwable)pce);
        }
        catch (SAXException se) {
            this.getLog().error((CharSequence)("Could not parse file: [" + this.contextFile.getAbsolutePath() + "]"), (Throwable)se);
        }
        return reloadable;
    }

    protected abstract File getDocBase();

    protected abstract File getContextFile() throws MojoExecutionException;

    protected boolean isWar() {
        return "war".equals(this.packaging) || this.ignorePackaging;
    }

    private URL getWebappUrl() throws MalformedURLException {
        return new URL("http", "localhost", this.port, this.getPath());
    }

    private void initConfiguration() throws IOException, MojoExecutionException, MavenFilteringException {
        if (this.configurationDir.exists()) {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.usingConfiguration", new Object[]{this.configurationDir}));
        } else {
            this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.creatingConfiguration", new Object[]{this.configurationDir}));
            this.configurationDir.mkdirs();
            File confDir = new File(this.configurationDir, "conf");
            confDir.mkdir();
            this.copyFile("/conf/tomcat-users.xml", new File(confDir, "tomcat-users.xml"));
            if (this.tomcatWebXml != null) {
                if (!this.tomcatWebXml.exists()) {
                    throw new MojoExecutionException(" tomcatWebXml " + this.tomcatWebXml.getPath() + " not exists");
                }
                FileUtils.copyFile((File)this.tomcatWebXml, (File)new File(confDir, "web.xml"));
                MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest();
                mavenFileFilterRequest.setFrom(this.tomcatWebXml);
                mavenFileFilterRequest.setTo(new File(confDir, "web.xml"));
                mavenFileFilterRequest.setMavenProject(this.project);
                mavenFileFilterRequest.setMavenSession(this.session);
                mavenFileFilterRequest.setFiltering(true);
                this.mavenFileFilter.copyFile(mavenFileFilterRequest);
            } else {
                this.copyFile("/conf/web.xml", new File(confDir, "web.xml"));
            }
            File logDir = new File(this.configurationDir, "logs");
            logDir.mkdir();
            File webappsDir = new File(this.configurationDir, "webapps");
            webappsDir.mkdir();
            if (this.managerWarPath != null && this.managerWarPath.exists()) {
                FileUtils.copyFileToDirectory((File)this.managerWarPath, (File)webappsDir);
            }
            if (this.additionalConfigFilesDir != null && this.additionalConfigFilesDir.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.addDefaultExcludes();
                scanner.setBasedir(this.additionalConfigFilesDir.getPath());
                scanner.scan();
                String[] files = scanner.getIncludedFiles();
                if (files != null && files.length > 0) {
                    this.getLog().info((CharSequence)"Coping additional tomcat config files");
                    for (int i = 0; i < files.length; ++i) {
                        File file = new File(this.additionalConfigFilesDir, files[i]);
                        this.getLog().info((CharSequence)(" copy " + file.getName()));
                        FileUtils.copyFileToDirectory((File)file, (File)confDir);
                    }
                }
            }
        }
    }

    private void copyFile(String fromPath, File toFile) throws IOException {
        URL fromURL = ((Object)((Object)this)).getClass().getResource(fromPath);
        if (fromURL == null) {
            throw new FileNotFoundException(fromPath);
        }
        FileUtils.copyURLToFile((URL)fromURL, (File)toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer() throws IOException, LifecycleException, MojoExecutionException {
        String previousCatalinaBase = System.getProperty("catalina.base");
        try {
            Embedded container;
            this.setupSystemProperties();
            System.setProperty("catalina.base", this.configurationDir.getAbsolutePath());
            System.setProperty("catalina.home", this.configurationDir.getAbsolutePath());
            File catalinaPolicy = new File(this.configurationDir, "conf/catalina.policy");
            if (catalinaPolicy.exists()) {
                System.setProperty("java.security.policy", catalinaPolicy.getAbsolutePath());
            }
            if (this.serverXml != null) {
                if (!this.serverXml.exists()) {
                    throw new MojoExecutionException(this.serverXml.getPath() + " not exists");
                }
                container = new Catalina();
                container.setCatalinaHome(this.configurationDir.getAbsolutePath());
                container.setCatalinaBase(this.configurationDir.getAbsolutePath());
                ((Catalina)container).setConfigFile(this.serverXml.getPath());
                ((Catalina)container).setRedirectStreams(true);
                ((Catalina)container).setUseNaming(this.useNaming);
                container.start();
            } else {
                container = new Embedded();
                container.setCatalinaHome(this.configurationDir.getAbsolutePath());
                MemoryRealm memoryRealm = new MemoryRealm();
                if (this.tomcatUsers != null) {
                    if (!this.tomcatUsers.exists()) {
                        throw new MojoExecutionException(" tomcatUsers " + this.tomcatUsers.getPath() + " not exists");
                    }
                    this.getLog().info((CharSequence)("use tomcat-users.xml from " + this.tomcatUsers.getAbsolutePath()));
                    memoryRealm.setPathname(this.tomcatUsers.getAbsolutePath());
                }
                container.setRealm((Realm)memoryRealm);
                container.setUseNaming(this.useNaming);
                Context context = this.createContext(container);
                String appBase = new File(this.configurationDir, "webapps").getAbsolutePath();
                Host host = container.createHost("localHost", appBase);
                if (this.hostName != null) {
                    host.setName(this.hostName);
                }
                if (this.aliases != null) {
                    for (String alias : this.aliases) {
                        host.addAlias(alias);
                    }
                }
                host.addChild((Container)context);
                this.createStaticContext(container, context, host);
                if (this.addContextWarDependencies || !this.getAdditionalWebapps().isEmpty()) {
                    Collection<Context> dependencyContexts = this.createDependencyContexts(container);
                    for (Context extraContext : dependencyContexts) {
                        host.addChild((Container)extraContext);
                    }
                }
                Engine engine = container.createEngine();
                engine.setName("localEngine-" + this.port);
                engine.addChild((Container)host);
                engine.setDefaultHost(host.getName());
                container.addEngine(engine);
                this.getLog().debug((CharSequence)("start tomcat instance on http port:" + this.port + " and protocol: " + this.protocol));
                Connector httpConnector = container.createConnector((InetAddress)null, this.port, this.protocol);
                if (this.httpsPort > 0) {
                    httpConnector.setRedirectPort(this.httpsPort);
                }
                httpConnector.setURIEncoding(this.uriEncoding);
                httpConnector.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
                if (this.address != null) {
                    httpConnector.setAttribute("address", (Object)this.address);
                }
                container.addConnector(httpConnector);
                if (this.httpsPort > 0) {
                    Connector httpsConnector = container.createConnector((InetAddress)null, this.httpsPort, true);
                    httpsConnector.setSecure(true);
                    httpsConnector.setProperty("SSLEnabled", "true");
                    httpsConnector.setProperty("sslProtocol", "TLS");
                    if (this.keystoreFile != null) {
                        httpsConnector.setAttribute("keystoreFile", (Object)this.keystoreFile);
                    }
                    if (this.keystorePass != null) {
                        httpsConnector.setAttribute("keystorePass", (Object)this.keystorePass);
                    }
                    if (this.keystoreType != null) {
                        httpsConnector.setAttribute("keystoreType", (Object)this.keystoreType);
                    }
                    if (this.truststoreFile != null) {
                        httpsConnector.setAttribute("truststoreFile", (Object)this.truststoreFile);
                    }
                    if (this.truststorePass != null) {
                        httpsConnector.setAttribute("truststorePass", (Object)this.truststorePass);
                    }
                    if (this.truststoreType != null) {
                        httpsConnector.setAttribute("truststoreType", (Object)this.truststoreType);
                    }
                    if (this.truststoreProvider != null) {
                        httpsConnector.setAttribute("truststoreProvider", (Object)this.truststoreProvider);
                    }
                    httpsConnector.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
                    if (this.address != null) {
                        httpsConnector.setAttribute("address", (Object)this.address);
                    }
                    container.addConnector(httpsConnector);
                }
                if (this.ajpPort > 0) {
                    Connector ajpConnector = container.createConnector((InetAddress)null, this.ajpPort, this.ajpProtocol);
                    ajpConnector.setURIEncoding(this.uriEncoding);
                    ajpConnector.setUseBodyEncodingForURI(this.useBodyEncodingForURI);
                    if (this.address != null) {
                        ajpConnector.setAttribute("address", (Object)this.address);
                    }
                    container.addConnector(ajpConnector);
                }
                if (this.useSeparateTomcatClassLoader) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)this.getTomcatClassLoader());
                    engine.setParentClassLoader((ClassLoader)this.getTomcatClassLoader());
                }
                container.start();
            }
            EmbeddedRegistry.getInstance().register((Object)container);
        }
        finally {
            if (previousCatalinaBase != null) {
                System.setProperty("catalina.base", previousCatalinaBase);
            }
        }
    }

    private List<Webapp> getAdditionalWebapps() {
        if (this.webapps == null) {
            return Collections.emptyList();
        }
        return this.webapps;
    }

    protected ClassRealm getTomcatClassLoader() throws MojoExecutionException {
        if (this.tomcatRealm != null) {
            return this.tomcatRealm;
        }
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm root = world.newRealm("tomcat", Thread.currentThread().getContextClassLoader());
            for (Artifact pluginArtifact : this.pluginArtifacts) {
                if (pluginArtifact.getFile() == null) continue;
                root.addURL(pluginArtifact.getFile().toURI().toURL());
            }
            this.tomcatRealm = root;
            return root;
        }
        catch (DuplicateRealmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public Set<Artifact> getProjectArtifacts() {
        return this.project.getArtifacts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                this.getLog().warn((CharSequence)this.messagesProvider.getMessage("AbstractRunMojo.interrupted"), (Throwable)exception);
            }
        }
    }

    private void setupSystemProperties() {
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            this.getLog().info((CharSequence)"setting SystemProperties:");
            for (String key : this.systemProperties.keySet()) {
                String value = this.systemProperties.get(key);
                if (value != null) {
                    this.getLog().info((CharSequence)(" " + key + "=" + value));
                    System.setProperty(key, value);
                    continue;
                }
                this.getLog().info((CharSequence)("skip sysProps " + key + " with empty value"));
            }
        }
    }

    private Collection<Context> createDependencyContexts(Embedded container) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Deploying dependency wars");
        ArrayList<Context> contexts = new ArrayList<Context>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("tomcat");
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"war".equals(artifact.getType()) || artifact.isOptional() || !filter.include(artifact)) continue;
            this.addContextFromArtifact(container, contexts, artifact, "/" + artifact.getArtifactId(), null);
        }
        for (Webapp additionalWebapp : this.getAdditionalWebapps()) {
            String contextPath = additionalWebapp.getContextPath();
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            this.addContextFromArtifact(container, contexts, this.getArtifact(additionalWebapp), contextPath, additionalWebapp.getContextFile());
        }
        return contexts;
    }

    private void addContextFromArtifact(Embedded container, List<Context> contexts, Artifact artifact, String contextPath, File contextXml) throws MojoExecutionException {
        File contextFile;
        this.getLog().info((CharSequence)("Deploy warfile: " + String.valueOf(artifact.getFile()) + " to contextPath: " + contextPath));
        File webapps = new File(this.configurationDir, "webapps");
        File artifactWarDir = new File(webapps, artifact.getArtifactId());
        if (!artifactWarDir.exists()) {
            artifactWarDir.mkdir();
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
                unArchiver.setSourceFile(artifact.getFile());
                unArchiver.setDestDirectory(artifactWarDir);
                unArchiver.extract();
            }
            catch (NoSuchArchiverException e) {
                this.getLog().error((Throwable)e);
                return;
            }
            catch (ArchiverException e) {
                this.getLog().error((Throwable)e);
                return;
            }
        }
        WebappLoader webappLoader = new WebappLoader(Thread.currentThread().getContextClassLoader());
        Context context = container.createContext(contextPath, artifactWarDir.getAbsolutePath());
        context.setLoader((Loader)webappLoader);
        File file = contextFile = contextXml != null ? contextXml : this.getContextFile();
        if (contextFile != null) {
            context.setConfigFile(contextFile.getAbsolutePath());
        }
        contexts.add(context);
    }

    private void createStaticContext(Embedded container, Context context, Host host) {
        if (this.staticContextDocbase != null) {
            Context staticContext = container.createContext(this.staticContextPath, this.staticContextDocbase);
            staticContext.setPrivileged(true);
            Wrapper servlet = context.createWrapper();
            servlet.setServletClass(DefaultServlet.class.getName());
            servlet.setName("staticContent");
            staticContext.addChild((Container)servlet);
            staticContext.addServletMapping("/", "staticContent");
            host.addChild((Container)staticContext);
        }
    }

    protected Artifact getArtifact(AbstractWebapp additionalWebapp) throws MojoExecutionException {
        VersionRange vr;
        try {
            vr = VersionRange.createFromVersionSpec((String)additionalWebapp.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            this.getLog().warn((CharSequence)("fail to create versionRange from version: " + additionalWebapp.getVersion()), (Throwable)e);
            vr = VersionRange.createFromVersion((String)additionalWebapp.getVersion());
        }
        Artifact artifact = StringUtils.isEmpty((String)additionalWebapp.getClassifier()) ? this.artifactFactory.createDependencyArtifact(additionalWebapp.getGroupId(), additionalWebapp.getArtifactId(), vr, additionalWebapp.getType(), null, "compile") : this.artifactFactory.createDependencyArtifact(additionalWebapp.getGroupId(), additionalWebapp.getArtifactId(), vr, additionalWebapp.getType(), additionalWebapp.getClassifier(), "compile");
        try {
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.artifactRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }
}

