/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JreMemoryLeakPreventionListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JreMemoryLeakPreventionListener.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private boolean appContextProtection = true;
    private boolean keepAliveProtection = true;
    private boolean urlCacheProtection = true;
    private boolean xmlParsingProtection = true;
    private boolean gcDaemonProtection = true;

    public boolean isAppContextProtection() {
        return this.appContextProtection;
    }

    public void setAppContextProtection(boolean appContextProtection) {
        this.appContextProtection = appContextProtection;
    }

    public boolean isKeepAliveProtection() {
        return this.keepAliveProtection;
    }

    public void setKeepAliveProtection(boolean keepAliveProtection) {
        this.keepAliveProtection = keepAliveProtection;
    }

    public boolean isUrlCacheProtection() {
        return this.urlCacheProtection;
    }

    public void setUrlCacheProtection(boolean urlCacheProtection) {
        this.urlCacheProtection = urlCacheProtection;
    }

    public boolean isXmlParsingProtection() {
        return this.xmlParsingProtection;
    }

    public void setXmlParsingProtection(boolean xmlParsingProtection) {
        this.xmlParsingProtection = xmlParsingProtection;
    }

    public boolean isGcDaemonProtection() {
        return this.gcDaemonProtection;
    }

    public void setGcDaemonProtection(boolean gcDaemonProtection) {
        this.gcDaemonProtection = gcDaemonProtection;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType())) {
            if (this.appContextProtection) {
                ImageIO.getCacheDirectory();
            }
            if (this.gcDaemonProtection) {
                try {
                    Class<?> clazz = Class.forName("sun.misc.GC");
                    Method method = clazz.getDeclaredMethod("requestLatency", Long.TYPE);
                    method.invoke(null, 3600000L);
                }
                catch (ClassNotFoundException e) {
                    if (System.getProperty("java.vendor").startsWith("Sun")) {
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    } else {
                        log.debug((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                }
                catch (SecurityException e) {
                    log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                }
            }
            if (this.keepAliveProtection) {
                try {
                    Class.forName("sun.net.www.http.HttpClient");
                }
                catch (ClassNotFoundException e) {
                    if (System.getProperty("java.vendor").startsWith("Sun")) {
                        log.error((Object)sm.getString("jreLeakListener.keepAliveFail"), (Throwable)e);
                    }
                    log.debug((Object)sm.getString("jreLeakListener.keepAliveFail"), (Throwable)e);
                }
            }
            if (this.urlCacheProtection) {
                try {
                    URL url = new URL("jar:file://dummy.jar!/");
                    URLConnection uConn = url.openConnection();
                    uConn.setDefaultUseCaches(false);
                }
                catch (MalformedURLException e) {
                    log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                }
            }
            if (this.xmlParsingProtection) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    log.error((Object)sm.getString("jreLeakListener.xmlParseFail"), (Throwable)e);
                }
            }
        }
    }
}

