/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.util;

import org.apache.tapestry.ioc.util.UtilMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack<E> {
    private static final int MINIMUM_SIZE = 3;
    private static final int DEFAULT_ARRAY_SIZE = 20;
    private Object[] _items;
    private int _index = -1;

    public Stack() {
        this(20);
    }

    public Stack(int initialSize) {
        this._items = new Object[Math.max(initialSize, 3)];
    }

    public boolean isEmpty() {
        return this._index < 0;
    }

    public void clear() {
        for (int i = 0; i <= this._index; ++i) {
            this._items[i] = null;
        }
        this._index = -1;
    }

    public void push(E item) {
        ++this._index;
        if (this._index == this._items.length) {
            int newCapacity = this._items.length * 3 / 2 + 1;
            Object[] newItems = new Object[newCapacity];
            System.arraycopy(this._items, 0, newItems, 0, this._items.length);
            this._items = newItems;
        }
        this._items[this._index] = item;
    }

    public E pop() {
        this.checkIfEmpty();
        Object result = this._items[this._index];
        this._items[this._index] = null;
        --this._index;
        return (E)result;
    }

    private void checkIfEmpty() {
        if (this._index < 0) {
            throw new IllegalStateException(UtilMessages.stackIsEmpty());
        }
    }

    public E peek() {
        this.checkIfEmpty();
        return (E)this._items[this._index];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Stack[");
        for (int i = this._index; i >= 0; --i) {
            if (i != this._index) {
                builder.append(", ");
            }
            builder.append(String.valueOf(this._items[i]));
        }
        builder.append("]");
        return builder.toString();
    }

    public Object[] getSnapshot() {
        Object[] result = new Object[this._index + 1];
        System.arraycopy(this._items, 0, result, 0, this._index + 1);
        return result;
    }
}

