/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveMap<V>
extends AbstractMap<String, V>
implements Serializable {
    private static final long serialVersionUID = 3362718337611953298L;
    private static final int NULL_HASH = Integer.MIN_VALUE;
    private static final int DEFAULT_SIZE = 20;
    private CIMEntry<V>[] _entries;
    private int _size = 0;
    private transient int _modCount = 0;
    private transient Set<Map.Entry<String, V>> _entrySet;

    public CaseInsensitiveMap() {
        this(20);
    }

    public CaseInsensitiveMap(int size) {
        this._entries = new CIMEntry[Math.max(size, 3)];
    }

    public CaseInsensitiveMap(Map<String, ? extends V> map) {
        this(map.size());
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this._size; ++i) {
            this._entries[i] = null;
        }
        this._size = 0;
        ++this._modCount;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public V put(String key, V value) {
        int hashCode = CaseInsensitiveMap.caseInsenitiveHashCode(key);
        return this.select(key, hashCode).put(key, hashCode, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.select(key).isFound();
    }

    @Override
    public V get(Object key) {
        return this.select(key).get();
    }

    @Override
    public V remove(Object key) {
        return this.select(key).remove();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new EntrySet();
        }
        return this._entrySet;
    }

    private Position select(Object key) {
        if (key == null || key instanceof String) {
            String keyString = (String)key;
            return this.select(keyString, CaseInsensitiveMap.caseInsenitiveHashCode(keyString));
        }
        return new Position(0, false);
    }

    private Position select(String key, int hashCode) {
        if (this._size == 0) {
            return new Position(0, false);
        }
        int low = 0;
        int high = this._size - 1;
        while (low <= high) {
            int cursor = low + high >> 1;
            CIMEntry<V> e = this._entries[cursor];
            if (((CIMEntry)e)._hashCode < hashCode) {
                low = cursor + 1;
                continue;
            }
            if (((CIMEntry)e)._hashCode > hashCode) {
                high = cursor - 1;
                continue;
            }
            return this.tunePosition(key, hashCode, cursor);
        }
        return new Position(low, false);
    }

    private Position tunePosition(String key, int hashCode, int cursor) {
        boolean found = false;
        while (cursor > 0 && ((CIMEntry)this._entries[cursor - 1])._hashCode == hashCode) {
            --cursor;
        }
        do {
            if (!this._entries[cursor].matches(key)) continue;
            found = true;
            break;
        } while (++cursor < this._size && ((CIMEntry)this._entries[cursor])._hashCode == hashCode);
        return new Position(cursor, found);
    }

    static int caseInsenitiveHashCode(String input) {
        if (input == null) {
            return Integer.MIN_VALUE;
        }
        int length = input.length();
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            int caselessCh = Character.toLowerCase((int)ch);
            hash = 31 * hash + caselessCh;
        }
        return hash;
    }

    static /* synthetic */ CIMEntry[] access$202(CaseInsensitiveMap x0, CIMEntry[] x1) {
        x0._entries = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Position {
        private final int _cursor;
        private final boolean _found;

        Position(int cursor, boolean found) {
            this._cursor = cursor;
            this._found = found;
        }

        boolean isFound() {
            return this._found;
        }

        CIMEntry<V> entry() {
            return CaseInsensitiveMap.this._entries[this._cursor];
        }

        V get() {
            return this._found ? (Object)((CaseInsensitiveMap)CaseInsensitiveMap.this)._entries[this._cursor]._value : null;
        }

        V remove() {
            if (!this._found) {
                return null;
            }
            Object result = ((CaseInsensitiveMap)CaseInsensitiveMap.this)._entries[this._cursor]._value;
            System.arraycopy(CaseInsensitiveMap.this._entries, this._cursor + 1, CaseInsensitiveMap.this._entries, this._cursor, CaseInsensitiveMap.this._size - this._cursor - 1);
            ((CaseInsensitiveMap)CaseInsensitiveMap.this)._entries[--((CaseInsensitiveMap)CaseInsensitiveMap.this)._size] = null;
            CaseInsensitiveMap.this._modCount++;
            return result;
        }

        V put(String key, int hashCode, V newValue) {
            CIMEntry newEntry;
            if (this._found) {
                CIMEntry e = CaseInsensitiveMap.this._entries[this._cursor];
                Object result = e._value;
                e._key = key;
                e._value = newValue;
                return result;
            }
            int newSize = CaseInsensitiveMap.this._size + 1;
            if (newSize == CaseInsensitiveMap.this._entries.length) {
                int newCapacity = CaseInsensitiveMap.this._size * 3 / 2 + 1;
                CIMEntry[] newEntries = new CIMEntry[newCapacity];
                System.arraycopy(CaseInsensitiveMap.this._entries, 0, newEntries, 0, this._cursor);
                System.arraycopy(CaseInsensitiveMap.this._entries, this._cursor, newEntries, this._cursor + 1, CaseInsensitiveMap.this._size - this._cursor);
                CaseInsensitiveMap.access$202(CaseInsensitiveMap.this, newEntries);
            } else {
                System.arraycopy(CaseInsensitiveMap.this._entries, this._cursor, CaseInsensitiveMap.this._entries, this._cursor + 1, CaseInsensitiveMap.this._size - this._cursor);
            }
            ((CaseInsensitiveMap)CaseInsensitiveMap.this)._entries[this._cursor] = newEntry = new CIMEntry(key, hashCode, newValue);
            CaseInsensitiveMap.this._size++;
            CaseInsensitiveMap.this._modCount++;
            return null;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntrySetIterator();
        }

        public int size() {
            return CaseInsensitiveMap.this._size;
        }

        public void clear() {
            CaseInsensitiveMap.this.clear();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Position position = CaseInsensitiveMap.this.select(e.getKey());
            return position.isFound() && position.entry().valueMatches(e.getValue());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Position position = CaseInsensitiveMap.this.select(e.getKey());
            if (position.isFound() && position.entry().valueMatches(e.getValue())) {
                position.remove();
                return true;
            }
            return false;
        }
    }

    private class EntrySetIterator
    implements Iterator {
        int _expectedModCount;
        int _index;
        int _current;

        private EntrySetIterator() {
            this._expectedModCount = CaseInsensitiveMap.this._modCount;
            this._current = -1;
        }

        public boolean hasNext() {
            return this._index < CaseInsensitiveMap.this._size;
        }

        public Object next() {
            this.check();
            if (this._index >= CaseInsensitiveMap.this._size) {
                throw new NoSuchElementException();
            }
            this._current = this._index++;
            return CaseInsensitiveMap.this._entries[this._current];
        }

        public void remove() {
            this.check();
            if (this._current < 0) {
                throw new NoSuchElementException();
            }
            new Position(this._current, true).remove();
            this._expectedModCount = CaseInsensitiveMap.this._modCount;
        }

        private void check() {
            if (this._expectedModCount != CaseInsensitiveMap.this._modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CIMEntry<V>
    implements Map.Entry<String, V>,
    Serializable {
        private static final long serialVersionUID = 6713986085221148350L;
        private String _key;
        private final int _hashCode;
        V _value;

        public CIMEntry(String key, int hashCode, V value) {
            this._key = key;
            this._hashCode = hashCode;
            this._value = value;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            V result = this._value;
            this._value = value;
            return result;
        }

        boolean matches(String key) {
            return key == this._key || key != null && key.equalsIgnoreCase(this._key);
        }

        boolean valueMatches(Object value) {
            return value == this._value || value != null && value.equals(this._value);
        }
    }
}

