/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.test;

import org.easymock.EasyMock;
import org.easymock.IMocksControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockTester {
    private final ThreadLocalControl _localControl = new ThreadLocalControl();

    public synchronized void cleanup() {
        this._localControl.remove();
    }

    public synchronized IMocksControl getMocksControl() {
        return (IMocksControl)this._localControl.get();
    }

    public <T> T newMock(Class<T> mockClass) {
        return (T)this.getMocksControl().createMock(mockClass.getSimpleName(), mockClass);
    }

    public void replay() {
        this.getMocksControl().replay();
    }

    public void verify() {
        IMocksControl control = this.getMocksControl();
        control.verify();
        control.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalControl
    extends ThreadLocal<IMocksControl> {
        private ThreadLocalControl() {
        }

        @Override
        protected IMocksControl initialValue() {
            return EasyMock.createControl();
        }
    }
}

