/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.internal.AbstractServiceCreator;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBuilderMethodInvoker
extends AbstractServiceCreator {
    private final Method _builderMethod;

    public ServiceBuilderMethodInvoker(ServiceBuilderResources resources, String creatorDescription, Method method) {
        super(resources, creatorDescription);
        this._builderMethod = method;
    }

    private Map<Class, Object> getParameterDefaultsWithConfigurations() {
        return this.getParameterDefaultsWithConfiguration(this._builderMethod.getParameterTypes(), this._builderMethod.getGenericParameterTypes());
    }

    @Override
    public Object createObject() {
        Object moduleBuilder = InternalUtils.isStatic(this._builderMethod) ? null : this._resources.getModuleBuilder();
        Object result = null;
        Throwable failure = null;
        try {
            Object[] parameters = InternalUtils.calculateParametersForMethod(this._builderMethod, this._resources, this.getParameterDefaultsWithConfigurations());
            if (this._logger.isDebugEnabled()) {
                this._logger.debug(IOCMessages.invokingMethod(this._creatorDescription));
            }
            result = this._builderMethod.invoke(moduleBuilder, parameters);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        if (failure != null) {
            throw new RuntimeException(IOCMessages.builderMethodError(this._creatorDescription, this._serviceId, failure), failure);
        }
        if (result == null) {
            throw new RuntimeException(IOCMessages.builderMethodReturnedNull(this._creatorDescription, this._serviceId));
        }
        return result;
    }
}

