/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitemesh;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.xwork2.ActionContext;
import freemarker.core.InvalidReferenceException;
import freemarker.ext.servlet.FreemarkerServlet;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.StrutsRequestWrapper;
import org.apache.struts2.dispatcher.listener.StrutsListener;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.freemarker.ScopesHashModel;

public class FreemarkerDecoratorServlet
extends FreemarkerServlet {
    private static final Logger LOG = LogManager.getLogger(FreemarkerDecoratorServlet.class);
    public static final long serialVersionUID = -2440216393145762479L;
    protected FreemarkerManager freemarkerManager;
    protected String templatePath;
    protected boolean nocache;
    protected boolean debug;
    protected Configuration config;
    private ObjectWrapper wrapper;
    private String contentType;
    private boolean noCharsetInContentType;

    public void init() throws ServletException {
        try {
            Dispatcher dispatcher = (Dispatcher)this.getServletContext().getAttribute("com.opensymphony.xwork2.dispatcher.ServletDispatcher");
            if (dispatcher == null) {
                throw new IllegalStateException("Unable to find the Dispatcher in the Servlet Context. Is '" + StrutsListener.class.getName() + "' missing in web.xml?");
            }
            this.freemarkerManager = (FreemarkerManager)dispatcher.getContainer().getInstance(FreemarkerManager.class);
            this.config = this.createConfiguration();
            this.wrapper = this.config.getObjectWrapper();
            LOG.debug("Using object wrapper of class {}", new Object[]{this.wrapper.getClass().getName()});
            Enumeration initpnames = this.getServletConfig().getInitParameterNames();
            while (initpnames.hasMoreElements()) {
                String name = (String)initpnames.nextElement();
                String value = this.getInitParameter(name);
                if (name == null) {
                    throw new ServletException("init-param without param-name. Maybe the web.xml is not well-formed?");
                }
                if (value == null) {
                    throw new ServletException("init-param without param-value. Maybe the web.xml is not well-formed?");
                }
                if ("TemplatePath".equals(name)) continue;
                this.freemarkerManager.addSetting(name, value);
            }
            this.nocache = this.freemarkerManager.getNocache();
            this.debug = this.freemarkerManager.getDebug();
            this.contentType = this.freemarkerManager.getContentType();
            this.noCharsetInContentType = this.freemarkerManager.getNoCharsetInContentType();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block22: {
            Template template;
            if (this.preprocessRequest(request, response)) {
                return;
            }
            String path = this.requestUrlToTemplatePath(request);
            if (this.debug) {
                this.log("Requested template: " + path);
            }
            try {
                template = this.config.getTemplate(path, this.deduceLocale(path, request, response));
            }
            catch (FileNotFoundException e) {
                response.sendError(404);
                return;
            }
            Object attrContentType = template.getCustomAttribute("content_type");
            if (attrContentType != null) {
                response.setContentType(attrContentType.toString());
            } else if (this.noCharsetInContentType) {
                response.setContentType(this.contentType + "; charset=" + template.getEncoding());
            } else {
                response.setContentType(this.contentType);
            }
            this.setBrowserCachingPolicy(response);
            ServletContext servletContext = this.getServletContext();
            ScopesHashModel model = (ScopesHashModel)request.getAttribute(".freemarker.TemplateModel");
            try {
                if (model == null) {
                    ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)request);
                    model = this.freemarkerManager.buildTemplateModel(ctx.getValueStack(), ctx.getActionInvocation().getAction(), servletContext, request, response, this.wrapper);
                }
                if (!this.preTemplateProcess(request, response, template, (TemplateModel)model)) break block22;
                try {
                    template.process((Object)model, (Writer)response.getWriter());
                }
                finally {
                    this.postTemplateProcess(request, response, template, (TemplateModel)model);
                }
            }
            catch (InvalidReferenceException x) {
                StrutsRequestWrapper req = (StrutsRequestWrapper)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                String resultCode = ActionContext.getContext().getActionInvocation().getResultCode();
                if (req == null) {
                    req = request;
                }
                StringBuilder msgBuf = new StringBuilder("Error applying freemarker template to\n       request: ");
                msgBuf.append(req.getRequestURL());
                if (req.getQueryString() != null) {
                    msgBuf.append("?").append(req.getQueryString());
                }
                msgBuf.append(" with resultCode: ").append(resultCode).append(".\n\n").append(x.getMessage());
                String msg = msgBuf.toString();
                LOG.error(msg, (Throwable)x);
                ServletException e = new ServletException(msg, (Throwable)x);
                try {
                    ((Object)((Object)e)).getClass().getMethod("initCause", Throwable.class).invoke((Object)e, new Object[]{x});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            catch (TemplateException te) {
                if (this.config.getTemplateExceptionHandler().getClass().getName().indexOf("Debug") != -1) {
                    this.log("Error executing FreeMarker template", te);
                }
                ServletException e = new ServletException("Error executing FreeMarker template", (Throwable)te);
                try {
                    ((Object)((Object)e)).getClass().getMethod("initCause", Throwable.class).invoke((Object)e, new Object[]{te});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    protected Locale deduceLocale(String templatePath, HttpServletRequest request, HttpServletResponse response) {
        return this.config.getLocale();
    }

    protected Configuration createConfiguration() {
        return this.freemarkerManager.getConfiguration(this.getServletContext());
    }

    protected boolean preTemplateProcess(HttpServletRequest request, HttpServletResponse response, Template template, TemplateModel templateModel) throws ServletException, IOException {
        String head;
        String body;
        String title;
        boolean result = super.preTemplateProcess(request, response, template, templateModel);
        SimpleHash hash = (SimpleHash)templateModel;
        HTMLPage htmlPage = (HTMLPage)request.getAttribute("__sitemesh__page");
        if (htmlPage == null) {
            title = "No Title";
            body = "No Body";
            head = "<!-- No head -->";
        } else {
            title = htmlPage.getTitle();
            StringWriter buffer = new StringWriter();
            htmlPage.writeBody((Writer)buffer);
            body = buffer.toString();
            buffer = new StringWriter();
            htmlPage.writeHead((Writer)buffer);
            head = buffer.toString();
            hash.put("page", (Object)htmlPage);
        }
        hash.put("title", (Object)title);
        hash.put("body", (Object)body);
        hash.put("head", (Object)head);
        hash.put("base", (Object)request.getContextPath());
        return result;
    }

    private void setBrowserCachingPolicy(HttpServletResponse res) {
        if (this.nocache) {
            res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
            res.setHeader("Pragma", "no-cache");
            res.setHeader("Expires", FreemarkerManager.EXPIRATION_DATE);
        }
    }
}

