/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.struts2.ServletActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONValidationInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JSONValidationInterceptor.class);
    private static final String VALIDATE_ONLY_PARAM = "struts.validateOnly";
    private static final String VALIDATE_JSON_PARAM = "struts.enableJSONValidation";
    private static final String NO_ENCODING_SET_PARAM = "struts.JSONValidation.no.encoding";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private int validationFailedStatus = -1;

    public void setValidationFailedStatus(int validationFailedStatus) {
        this.validationFailedStatus = validationFailedStatus;
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();
        Object action = invocation.getAction();
        if (this.isJsonEnabled(request)) {
            ValidationAware validationAware;
            if (action instanceof ValidationAware && (validationAware = (ValidationAware)action).hasErrors()) {
                return this.generateJSON(request, response, validationAware);
            }
            if (this.isValidateOnly(request)) {
                this.setupEncoding(response, request);
                response.getWriter().print("{}");
                response.setContentType("application/json");
                return "none";
            }
            return invocation.invoke();
        }
        return invocation.invoke();
    }

    private void setupEncoding(HttpServletResponse response, HttpServletRequest request) {
        if (this.isSetEncoding(request)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Default encoding not set!", new String[0]);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up encoding to: [UTF-8]!", new String[0]);
            }
            response.setCharacterEncoding(DEFAULT_ENCODING);
        }
    }

    private String generateJSON(HttpServletRequest request, HttpServletResponse response, ValidationAware validationAware) throws IOException {
        if (this.validationFailedStatus >= 0) {
            response.setStatus(this.validationFailedStatus);
        }
        this.setupEncoding(response, request);
        response.getWriter().print(this.buildResponse(validationAware));
        response.setContentType("application/json");
        return "none";
    }

    private boolean isJsonEnabled(HttpServletRequest request) {
        return "true".equals(request.getParameter(VALIDATE_JSON_PARAM));
    }

    private boolean isValidateOnly(HttpServletRequest request) {
        return "true".equals(request.getParameter(VALIDATE_ONLY_PARAM));
    }

    private boolean isSetEncoding(HttpServletRequest request) {
        return "true".equals(request.getParameter(NO_ENCODING_SET_PARAM));
    }

    protected String buildResponse(ValidationAware validationAware) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        if (validationAware.hasErrors()) {
            if (validationAware.hasActionErrors()) {
                sb.append("\"errors\":");
                sb.append(this.buildArray(validationAware.getActionErrors()));
            }
            if (validationAware.hasFieldErrors()) {
                if (validationAware.hasActionErrors()) {
                    sb.append(",");
                }
                sb.append("\"fieldErrors\": {");
                Map fieldErrors = validationAware.getFieldErrors();
                for (Map.Entry fieldError : fieldErrors.entrySet()) {
                    sb.append("\"");
                    String fieldErrorKey = (String)fieldError.getKey();
                    sb.append(validationAware instanceof ModelDriven && fieldErrorKey.startsWith("model.") ? fieldErrorKey.substring(6) : fieldErrorKey);
                    sb.append("\":");
                    sb.append(this.buildArray((Collection)fieldError.getValue()));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("}");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private String buildArray(Collection<String> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String value : values) {
            sb.append("\"");
            sb.append(StringEscapeUtils.escapeJson((String)value));
            sb.append("\",");
        }
        if (values.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }
}

