/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.rdd.PairRDDFunctions$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.scheduler.ErrorReported;
import org.apache.spark.streaming.scheduler.InputInfoTracker;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.streaming.scheduler.JobCompleted;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.streaming.scheduler.JobScheduler$;
import org.apache.spark.streaming.scheduler.JobSchedulerEvent;
import org.apache.spark.streaming.scheduler.JobSet;
import org.apache.spark.streaming.scheduler.JobStarted;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.ui.UIUtils$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.EventLoop;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tEa!B\u0001\u0003\u0001\u0011a!\u0001\u0004&pEN\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0002\u0005\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005\u0002i\t1a]:d\u0007\u0001)\u0012a\u0007\t\u00039ui\u0011\u0001B\u0005\u0003=\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\u0001\u0002!\u0011!Q\u0001\nm\tAa]:dA!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000ba\t\u0003\u0019A\u000e\t\u000f!\u0002!\u0019!C\u0005S\u00059!n\u001c2TKR\u001cX#\u0001\u0016\u0011\t-\u0002$'N\u0007\u0002Y)\u0011QFL\u0001\u0005kRLGNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#aA'baB\u0011AdM\u0005\u0003i\u0011\u0011A\u0001V5nKB\u0011QEN\u0005\u0003o\t\u0011aAS8c'\u0016$\bBB\u001d\u0001A\u0003%!&\u0001\u0005k_\n\u001cV\r^:!\u0011\u001dY\u0004A1A\u0005\nq\n\u0011C\\;n\u0007>t7-\u001e:sK:$(j\u001c2t+\u0005i\u0004C\u0001\b?\u0013\tytBA\u0002J]RDa!\u0011\u0001!\u0002\u0013i\u0014A\u00058v[\u000e{gnY;se\u0016tGOS8cg\u0002Bqa\u0011\u0001C\u0002\u0013%A)A\u0006k_\n,\u00050Z2vi>\u0014X#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!c\u0013AC2p]\u000e,(O]3oi&\u0011!j\u0012\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000f\u0003\u0004M\u0001\u0001\u0006I!R\u0001\rU>\u0014W\t_3dkR|'\u000f\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u00031QwNY$f]\u0016\u0014\u0018\r^8s+\u0005\u0001\u0006CA\u0013R\u0013\t\u0011&A\u0001\u0007K_\n<UM\\3sCR|'\u000f\u0003\u0004U\u0001\u0001\u0006I\u0001U\u0001\u000eU>\u0014w)\u001a8fe\u0006$xN\u001d\u0011\t\u000fY\u0003!\u0019!C\u0001/\u0006)1\r\\8dWV\t\u0001\f\u0005\u0002Z76\t!L\u0003\u0002.\r%\u0011AL\u0017\u0002\u0006\u00072|7m\u001b\u0005\u0007=\u0002\u0001\u000b\u0011\u0002-\u0002\r\rdwnY6!\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005\f1\u0002\\5ti\u0016tWM\u001d\"vgV\t!\r\u0005\u0002&G&\u0011AM\u0001\u0002\u0015'R\u0014X-Y7j]\u001ed\u0015n\u001d;f]\u0016\u0014()^:\t\r\u0019\u0004\u0001\u0015!\u0003c\u00031a\u0017n\u001d;f]\u0016\u0014()^:!\u0011\u001dA\u0007\u00011A\u0005\u0002%\fqB]3dK&4XM\u001d+sC\u000e\\WM]\u000b\u0002UB\u0011Qe[\u0005\u0003Y\n\u0011qBU3dK&4XM\u001d+sC\u000e\\WM\u001d\u0005\b]\u0002\u0001\r\u0011\"\u0001p\u0003M\u0011XmY3jm\u0016\u0014HK]1dW\u0016\u0014x\fJ3r)\t\u00018\u000f\u0005\u0002\u000fc&\u0011!o\u0004\u0002\u0005+:LG\u000fC\u0004u[\u0006\u0005\t\u0019\u00016\u0002\u0007a$\u0013\u0007\u0003\u0004w\u0001\u0001\u0006KA[\u0001\u0011e\u0016\u001cW-\u001b<feR\u0013\u0018mY6fe\u0002Bq\u0001\u001f\u0001A\u0002\u0013\u0005\u00110\u0001\tj]B,H/\u00138g_R\u0013\u0018mY6feV\t!\u0010\u0005\u0002&w&\u0011AP\u0001\u0002\u0011\u0013:\u0004X\u000f^%oM>$&/Y2lKJDqA \u0001A\u0002\u0013\u0005q0\u0001\u000bj]B,H/\u00138g_R\u0013\u0018mY6fe~#S-\u001d\u000b\u0004a\u0006\u0005\u0001b\u0002;~\u0003\u0003\u0005\rA\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003{\u0003EIg\u000e];u\u0013:4w\u000e\u0016:bG.,'\u000f\t\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017\t\u0011\"\u001a<f]Rdun\u001c9\u0016\u0005\u00055\u0001#B-\u0002\u0010\u0005M\u0011bAA\t5\nIQI^3oi2{w\u000e\u001d\t\u0004K\u0005U\u0011bAA\f\u0005\t\t\"j\u001c2TG\",G-\u001e7fe\u00163XM\u001c;\t\u0013\u0005m\u0001\u00011A\u0005\n\u0005u\u0011!D3wK:$Hj\\8q?\u0012*\u0017\u000fF\u0002q\u0003?A\u0011\u0002^A\r\u0003\u0003\u0005\r!!\u0004\t\u0011\u0005\r\u0002\u0001)Q\u0005\u0003\u001b\t!\"\u001a<f]Rdun\u001c9!\u0011\u001d\t9\u0003\u0001C\u0001\u0003S\tQa\u001d;beR$\u0012\u0001\u001d\u0005\b\u0003[\u0001A\u0011AA\u0018\u0003\u0011\u0019Ho\u001c9\u0015\u0007A\f\t\u0004\u0003\u0005\u00024\u0005-\u0002\u0019AA\u001b\u0003Y\u0001(o\\2fgN\fE\u000e\u001c*fG\u0016Lg/\u001a3ECR\f\u0007c\u0001\b\u00028%\u0019\u0011\u0011H\b\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001D:vE6LGOS8c'\u0016$Hc\u00019\u0002B!9\u00111IA\u001e\u0001\u0004)\u0014A\u00026pEN+G\u000fC\u0004\u0002H\u0001!\t!!\u0013\u0002\u001f\u001d,G\u000fU3oI&tw\rV5nKN$\"!a\u0013\u0011\u000b\u00055\u0013Q\f\u001a\u000f\t\u0005=\u0013\u0011\f\b\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011QK\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012bAA.\u001f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA0\u0003C\u00121aU3r\u0015\r\tYf\u0004\u0005\b\u0003K\u0002A\u0011AA4\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\u000bA\fI'a\u001f\t\u0011\u0005-\u00141\ra\u0001\u0003[\n1!\\:h!\u0011\ty'!\u001e\u000f\u00079\t\t(C\u0002\u0002t=\ta\u0001\u0015:fI\u00164\u0017\u0002BA<\u0003s\u0012aa\u0015;sS:<'bAA:\u001f!A\u0011QPA2\u0001\u0004\ty(A\u0001f!\u0011\ti%!!\n\t\u0005\r\u0015\u0011\r\u0002\n)\"\u0014xn^1cY\u0016Dq!a\"\u0001\t\u0003\tI)A\u0005jgN#\u0018M\u001d;fIR\u0011\u0011Q\u0007\u0005\b\u0003\u001b\u0003A\u0011BAH\u00031\u0001(o\\2fgN,e/\u001a8u)\r\u0001\u0018\u0011\u0013\u0005\t\u0003'\u000bY\t1\u0001\u0002\u0014\u0005)QM^3oi\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0015A\u00045b]\u0012dWMS8c'R\f'\u000f\u001e\u000b\u0006a\u0006m\u0015Q\u0015\u0005\t\u0003;\u000b)\n1\u0001\u0002 \u0006\u0019!n\u001c2\u0011\u0007\u0015\n\t+C\u0002\u0002$\n\u00111AS8c\u0011!\t9+!&A\u0002\u0005%\u0016!C:uCJ$H+[7f!\rq\u00111V\u0005\u0004\u0003[{!\u0001\u0002'p]\u001eDq!!-\u0001\t\u0013\t\u0019,A\niC:$G.\u001a&pE\u000e{W\u000e\u001d7fi&|g\u000eF\u0003q\u0003k\u000b9\f\u0003\u0005\u0002\u001e\u0006=\u0006\u0019AAP\u0011!\tI,a,A\u0002\u0005%\u0016!D2p[BdW\r^3e)&lW\rC\u0004\u0002>\u0002!I!a0\u0002\u0017!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u000b\u0006a\u0006\u0005\u00171\u0019\u0005\t\u0003W\nY\f1\u0001\u0002n!A\u0011QPA^\u0001\u0004\tyH\u0002\u0004\u0002H\u0002!\u0011\u0011\u001a\u0002\u000b\u0015>\u0014\u0007*\u00198eY\u0016\u00148cBAc\u0003\u0017\f9n\u0005\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*\u0019\u0011\u0011\u001b\u0018\u0002\t1\fgnZ\u0005\u0005\u0003+\fyM\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u001b\fI.\u0003\u0003\u0002\\\u0006='\u0001\u0003*v]:\f'\r\\3\t\u0017\u0005u\u0015Q\u0019B\u0001B\u0003%\u0011q\u0014\u0005\bE\u0005\u0015G\u0011AAq)\u0011\t\u0019/a:\u0011\t\u0005\u0015\u0018QY\u0007\u0002\u0001!A\u0011QTAp\u0001\u0004\ty\n\u0003\u0005\u0002l\u0006\u0015G\u0011AA\u0015\u0003\r\u0011XO\\\u0004\t\u0003_\u0014\u0001\u0012\u0001\u0003\u0002r\u0006a!j\u001c2TG\",G-\u001e7feB\u0019Q%a=\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0002vN\u0019\u00111_\u0007\t\u000f\t\n\u0019\u0010\"\u0001\u0002zR\u0011\u0011\u0011\u001f\u0005\u000b\u0003{\f\u0019P1A\u0005\u0002\u0005}\u0018a\u0006\"B)\u000eCu\fV%N\u000b~\u0003&k\u0014)F%RKvlS#Z+\t\u0011\t\u0001\u0005\u0003\u0002N\n\r\u0011\u0002BA<\u0003\u001fD\u0011Ba\u0002\u0002t\u0002\u0006IA!\u0001\u00021\t\u000bEk\u0011%`)&kUi\u0018)S\u001fB+%\u000bV-`\u0017\u0016K\u0006\u0005\u0003\u0006\u0003\f\u0005M(\u0019!C\u0001\u0003\u007f\f\u0011dT+U!V#vl\u0014)`\u0013\u0012{\u0006KU(Q\u000bJ#\u0016lX&F3\"I!qBAzA\u0003%!\u0011A\u0001\u001b\u001fV#\u0006+\u0016+`\u001fB{\u0016\nR0Q%>\u0003VI\u0015+Z?.+\u0015\f\t")
public class JobScheduler
implements Logging {
    private final StreamingContext ssc;
    private final Map<Time, JobSet> jobSets;
    private final int numConcurrentJobs;
    private final ThreadPoolExecutor org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor;
    private final JobGenerator jobGenerator;
    private final Clock clock;
    private final StreamingListenerBus listenerBus;
    private ReceiverTracker receiverTracker;
    private InputInfoTracker inputInfoTracker;
    private EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String OUTPUT_OP_ID_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY();
    }

    public static String BATCH_TIME_PROPERTY_KEY() {
        return JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    private Map<Time, JobSet> jobSets() {
        return this.jobSets;
    }

    private int numConcurrentJobs() {
        return this.numConcurrentJobs;
    }

    public ThreadPoolExecutor org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor;
    }

    private JobGenerator jobGenerator() {
        return this.jobGenerator;
    }

    public Clock clock() {
        return this.clock;
    }

    public StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker receiverTracker() {
        return this.receiverTracker;
    }

    public void receiverTracker_$eq(ReceiverTracker x$1) {
        this.receiverTracker = x$1;
    }

    public InputInfoTracker inputInfoTracker() {
        return this.inputInfoTracker;
    }

    public void inputInfoTracker_$eq(InputInfoTracker x$1) {
        this.inputInfoTracker = x$1;
    }

    public EventLoop<JobSchedulerEvent> org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop;
    }

    private void org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(EventLoop<JobSchedulerEvent> x$1) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = x$1;
    }

    public synchronized void start() {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobScheduler";
                }
            });
            this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(new EventLoop<JobSchedulerEvent>(this){
                private final /* synthetic */ JobScheduler $outer;

                public void onReceive(JobSchedulerEvent event) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(event);
                }

                public void onError(Throwable e) {
                    this.$outer.reportError("Error in job scheduler", e);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super("JobScheduler");
                }
            });
            this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().start();
            Predef$.MODULE$.refArrayOps((Object[])this.ssc().graph().getInputStreams()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final void apply(InputDStream<?> inputDStream) {
                    inputDStream.rateController().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$start$2 $outer;

                        public final void apply(RateController rateController) {
                            this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$$outer().ssc().addStreamingListener(rateController);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.listenerBus().start(this.ssc().sparkContext());
            this.receiverTracker_$eq(new ReceiverTracker(this.ssc(), ReceiverTracker$.MODULE$.$lessinit$greater$default$2()));
            this.inputInfoTracker_$eq(new InputInfoTracker(this.ssc()));
            this.receiverTracker().start();
            this.jobGenerator().start();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Started JobScheduler";
                }
            });
            return;
        }
    }

    public synchronized void stop(boolean processAllReceivedData) {
        if (this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() == null) {
            return;
        }
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping JobScheduler";
            }
        });
        if (this.receiverTracker() != null) {
            this.receiverTracker().stop(processAllReceivedData);
        }
        this.jobGenerator().stop(processAllReceivedData);
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopping job executor";
            }
        });
        this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().shutdown();
        boolean terminated = processAllReceivedData ? this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().awaitTermination(1L, TimeUnit.HOURS) : this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().awaitTermination(2L, TimeUnit.SECONDS);
        Object object = terminated ? BoxedUnit.UNIT : this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().shutdownNow();
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped job executor";
            }
        });
        this.listenerBus().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().stop();
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop_$eq(null);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped JobScheduler";
            }
        });
    }

    public void submitJobSet(JobSet jobSet) {
        if (jobSet.jobs().isEmpty()) {
            this.logInfo((Function0<String>)new Serializable(this, jobSet){
                public static final long serialVersionUID = 0L;
                private final JobSet jobSet$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"No jobs added for time ").append((Object)this.jobSet$1.time()).toString();
                }
                {
                    this.jobSet$1 = jobSet$1;
                }
            });
        } else {
            this.listenerBus().post(new StreamingListenerBatchSubmitted(jobSet.toBatchInfo()));
            this.jobSets().put(jobSet.time(), jobSet);
            jobSet.jobs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JobScheduler $outer;

                public final void apply(Job job) {
                    this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor().execute(new JobHandler(this.$outer, job));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, jobSet){
                public static final long serialVersionUID = 0L;
                private final JobSet jobSet$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Added jobs for time ").append((Object)this.jobSet$1.time()).toString();
                }
                {
                    this.jobSet$1 = jobSet$1;
                }
            });
        }
    }

    public Seq<Time> getPendingTimes() {
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.jobSets()).asScala()).keys().toSeq();
    }

    public void reportError(String msg, Throwable e) {
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop().post((Object)new ErrorReported(msg, e));
    }

    public synchronized boolean isStarted() {
        return this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop() != null;
    }

    public void org$apache$spark$streaming$scheduler$JobScheduler$$processEvent(JobSchedulerEvent event) {
        block5: {
            try {
                JobSchedulerEvent jobSchedulerEvent = event;
                if (jobSchedulerEvent instanceof JobStarted) {
                    JobStarted jobStarted = (JobStarted)jobSchedulerEvent;
                    Job job = jobStarted.job();
                    long startTime = jobStarted.startTime();
                    this.handleJobStart(job, startTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof JobCompleted) {
                    JobCompleted jobCompleted = (JobCompleted)jobSchedulerEvent;
                    Job job = jobCompleted.job();
                    long completedTime = jobCompleted.completedTime();
                    this.handleJobCompletion(job, completedTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (jobSchedulerEvent instanceof ErrorReported) {
                    ErrorReported errorReported = (ErrorReported)jobSchedulerEvent;
                    String m = errorReported.msg();
                    Throwable e = errorReported.e();
                    this.handleError(m, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                throw new MatchError((Object)jobSchedulerEvent);
            }
            catch (Throwable throwable) {
                this.reportError("Error in job scheduler", throwable);
            }
        }
    }

    private void handleJobStart(Job job, long startTime) {
        JobSet jobSet = this.jobSets().get(job.time());
        boolean isFirstJobOfJobSet = !jobSet.hasStarted();
        jobSet.handleJobStart(job);
        if (isFirstJobOfJobSet) {
            this.listenerBus().post(new StreamingListenerBatchStarted(jobSet.toBatchInfo()));
        }
        job.setStartTime(startTime);
        this.listenerBus().post(new StreamingListenerOutputOperationStarted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)new Serializable(this, job, jobSet){
            public static final long serialVersionUID = 0L;
            private final Job job$1;
            private final JobSet jobSet$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting job ").append((Object)this.job$1.id()).append((Object)" from job set of time ").append((Object)this.jobSet$2.time()).toString();
            }
            {
                this.job$1 = job$1;
                this.jobSet$2 = jobSet$2;
            }
        });
    }

    private void handleJobCompletion(Job job, long completedTime) {
        Try<?> try_;
        JobSet jobSet = this.jobSets().get(job.time());
        jobSet.handleJobCompletion(job);
        job.setEndTime(completedTime);
        this.listenerBus().post(new StreamingListenerOutputOperationCompleted(job.toOutputOperationInfo()));
        this.logInfo((Function0<String>)new Serializable(this, job, jobSet){
            public static final long serialVersionUID = 0L;
            private final Job job$2;
            private final JobSet jobSet$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Finished job ").append((Object)this.job$2.id()).append((Object)" from job set of time ").append((Object)this.jobSet$3.time()).toString();
            }
            {
                this.job$2 = job$2;
                this.jobSet$3 = jobSet$3;
            }
        });
        if (jobSet.hasCompleted()) {
            this.jobSets().remove(jobSet.time());
            this.jobGenerator().onBatchCompletion(jobSet.time());
            this.logInfo((Function0<String>)new Serializable(this, jobSet){
                public static final long serialVersionUID = 0L;
                private final JobSet jobSet$3;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Total delay: %.3f s for time %s (execution: %.3f s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)this.jobSet$3.totalDelay() / 1000.0)), this.jobSet$3.time().toString(), BoxesRunTime.boxToDouble((double)((double)this.jobSet$3.processingDelay() / 1000.0))}));
                }
                {
                    this.jobSet$3 = jobSet$3;
                }
            });
            this.listenerBus().post(new StreamingListenerBatchCompleted(jobSet.toBatchInfo()));
        }
        if ((try_ = job.result()) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.reportError(new StringBuilder().append((Object)"Error running job ").append((Object)job).toString(), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void handleError(String msg, Throwable e) {
        this.logError((Function0<String>)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final String apply() {
                return this.msg$1;
            }
            {
                this.msg$1 = msg$1;
            }
        }, e);
        this.ssc().waiter().notifyError(e);
    }

    public JobScheduler(StreamingContext ssc) {
        this.ssc = ssc;
        Logging.class.$init$((Logging)this);
        this.jobSets = new ConcurrentHashMap<Time, JobSet>();
        this.numConcurrentJobs = ssc.conf().getInt("spark.streaming.concurrentJobs", 1);
        this.org$apache$spark$streaming$scheduler$JobScheduler$$jobExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.numConcurrentJobs(), "streaming-job-executor");
        this.jobGenerator = new JobGenerator(this);
        this.clock = this.jobGenerator().clock();
        this.listenerBus = new StreamingListenerBus();
        this.receiverTracker = null;
        this.inputInfoTracker = null;
        this.org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop = null;
    }

    public class JobHandler
    implements Runnable,
    Logging {
        public final Job org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job;
        public final /* synthetic */ JobScheduler $outer;
        private transient Logger org$apache$spark$Logging$$log_;

        public Logger org$apache$spark$Logging$$log_() {
            return this.org$apache$spark$Logging$$log_;
        }

        public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$Logging$$log_ = x$1;
        }

        public String logName() {
            return Logging.class.logName((Logging)this);
        }

        public Logger log() {
            return Logging.class.log((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.class.logInfo((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.class.logDebug((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.class.logTrace((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.class.logWarning((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.class.logError((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.class.logError((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.class.isTraceEnabled((Logging)this);
        }

        @Override
        public void run() {
            try {
                String formattedTime = UIUtils$.MODULE$.formatBatchTime(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.time().milliseconds(), this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().graph().batchDuration().milliseconds(), false, UIUtils$.MODULE$.formatBatchTime$default$4());
                String batchUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/streaming/batch/?id=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.time().milliseconds())}));
                String batchLinkText = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[output operation ", ", batch time ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.outputOpId()), formattedTime}));
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setJobDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming job from <a href=\"", "\">", "</a>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchUrl, batchLinkText})));
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.time().milliseconds())).toString());
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY(), ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.outputOpId())).toString());
                EventLoop<JobSchedulerEvent> _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                if (_eventLoop != null) {
                    _eventLoop.post((Object)new JobStarted(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    PairRDDFunctions$.MODULE$.disableOutputSpecValidation().withValue((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ JobHandler $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job.run();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    _eventLoop = this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().org$apache$spark$streaming$scheduler$JobScheduler$$eventLoop();
                    if (_eventLoop != null) {
                        _eventLoop.post((Object)new JobCompleted(this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job, this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().clock().getTimeMillis()));
                    }
                }
                return;
            }
            finally {
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.BATCH_TIME_PROPERTY_KEY(), null);
                this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer().ssc().sc().setLocalProperty(JobScheduler$.MODULE$.OUTPUT_OP_ID_PROPERTY_KEY(), null);
            }
        }

        public /* synthetic */ JobScheduler org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$$outer() {
            return this.$outer;
        }

        public JobHandler(JobScheduler $outer, Job job) {
            this.org$apache$spark$streaming$scheduler$JobScheduler$JobHandler$$job = job;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.class.$init$((Logging)this);
        }
    }
}

