/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.shindig.common.util.Utf8UrlCoder;

public class ProxyServletRequest
extends HttpServletRequestWrapper {
    protected static final Pattern CHAINED_SYNTAX_PATTERN = Pattern.compile("^[^?]+/proxy/([^?/]*)/(.*)$");
    protected static final Pattern PARAMETER_PAIR_PATTERN = Pattern.compile("([^&=]+)=([^&=]*)");
    protected final boolean usingChainedSyntax;
    protected final Map<String, String> extractedParameters;

    public ProxyServletRequest(HttpServletRequest request) {
        super(request);
        Matcher chainedMatcher = CHAINED_SYNTAX_PATTERN.matcher(request.getRequestURI());
        this.usingChainedSyntax = chainedMatcher.matches();
        if (this.usingChainedSyntax) {
            this.extractedParameters = Maps.newHashMap();
            Matcher paramMatcher = PARAMETER_PAIR_PATTERN.matcher(chainedMatcher.group(1));
            while (paramMatcher.find()) {
                this.extractedParameters.put(Utf8UrlCoder.decode((String)paramMatcher.group(1)), Utf8UrlCoder.decode((String)paramMatcher.group(2)));
            }
            String urlParam = chainedMatcher.group(2);
            if (request.getQueryString() != null) {
                urlParam = urlParam + '?' + request.getQueryString();
            }
            this.extractedParameters.put("url", urlParam);
        } else {
            this.extractedParameters = Collections.emptyMap();
        }
    }

    public boolean isUsingChainedSyntax() {
        return this.usingChainedSyntax;
    }

    public String getParameter(String name) {
        if (this.usingChainedSyntax) {
            return this.extractedParameters.get(name);
        }
        return super.getParameter(name);
    }
}

