/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.util;

import java.math.BigInteger;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.mysql.type.MySQLDatabaseType;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.postgresql.type.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;

public final class SQLFederationDataTypeUtils {
    public static RelDataType createRelDataType(ShardingSphereTable table, DatabaseType protocolType, RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = typeFactory.builder();
        for (ShardingSphereColumn each : table.getColumnValues()) {
            fieldInfoBuilder.add(each.getName(), SQLFederationDataTypeUtils.getRelDataType(protocolType, each, typeFactory));
        }
        return fieldInfoBuilder.build();
    }

    private static RelDataType getRelDataType(DatabaseType protocolType, ShardingSphereColumn column, RelDataTypeFactory typeFactory) {
        Class<?> sqlTypeClass = SQLFederationDataTypeUtils.getSqlTypeClass(protocolType, column);
        RelDataType javaType = typeFactory.createJavaType(sqlTypeClass);
        return typeFactory.createTypeWithNullability(javaType, true);
    }

    public static Class<?> getSqlTypeClass(DatabaseType protocolType, ShardingSphereColumn column) {
        Optional<Object> typeClazz = Optional.empty();
        if (protocolType instanceof MySQLDatabaseType) {
            typeClazz = SQLFederationDataTypeUtils.findMySQLTypeClass(column);
        }
        if (protocolType instanceof PostgreSQLDatabaseType || protocolType instanceof OpenGaussDatabaseType) {
            typeClazz = SQLFederationDataTypeUtils.findPostgreSQLTypeClass(column);
        }
        return typeClazz.orElseGet(() -> SqlType.valueOf((int)column.getDataType()).clazz);
    }

    private static Optional<Class<?>> findPostgreSQLTypeClass(ShardingSphereColumn column) {
        if (5 == column.getDataType()) {
            return Optional.of(Integer.class);
        }
        return Optional.empty();
    }

    private static Optional<Class<?>> findMySQLTypeClass(ShardingSphereColumn column) {
        if (-6 == column.getDataType() || 5 == column.getDataType()) {
            return Optional.of(Integer.class);
        }
        if (4 == column.getDataType()) {
            return column.isUnsigned() ? Optional.of(Long.class) : Optional.of(Integer.class);
        }
        if (-5 == column.getDataType()) {
            return column.isUnsigned() ? Optional.of(BigInteger.class) : Optional.of(Long.class);
        }
        return Optional.empty();
    }

    @Generated
    private SQLFederationDataTypeUtils() {
    }
}

