/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlValuesOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.SQLStatementConverter;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.statement.select.SelectStatementConverter;

public final class InsertStatementConverter
implements SQLStatementConverter<InsertStatement, SqlNode> {
    @Override
    public SqlNode convert(InsertStatement insertStatement) {
        return this.convertInsert(insertStatement);
    }

    private SqlInsert convertInsert(InsertStatement insertStatement) {
        SqlNode table = TableConverter.convert((TableSegment)insertStatement.getTable()).orElseThrow(IllegalStateException::new);
        SqlNodeList keywords = new SqlNodeList(SqlParserPos.ZERO);
        SqlNode source = this.convertSource(insertStatement);
        SqlNodeList columnList = this.convertColumn(insertStatement.getColumns());
        return new SqlInsert(SqlParserPos.ZERO, keywords, table, source, columnList);
    }

    private SqlNode convertSource(InsertStatement insertStatement) {
        if (insertStatement.getInsertSelect().isPresent()) {
            return new SelectStatementConverter().convert(((SubquerySegment)insertStatement.getInsertSelect().get()).getSelect());
        }
        return this.convertValues(insertStatement.getValues());
    }

    private SqlNode convertValues(Collection<InsertValuesSegment> insertValuesSegments) {
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        for (InsertValuesSegment each : insertValuesSegments) {
            for (ExpressionSegment value : each.getValues()) {
                values.add(this.convertExpression(value));
            }
        }
        List<SqlBasicCall> operands = Collections.singletonList(new SqlBasicCall((SqlOperator)new SqlRowOperator("ROW"), values, SqlParserPos.ZERO));
        return new SqlBasicCall((SqlOperator)new SqlValuesOperator(), operands, SqlParserPos.ZERO);
    }

    private SqlNodeList convertColumn(Collection<ColumnSegment> columnSegments) {
        List columns = columnSegments.stream().map(each -> ColumnConverter.convert(each).orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        return columns.isEmpty() ? null : new SqlNodeList(columns, SqlParserPos.ZERO);
    }

    private SqlNode convertExpression(ExpressionSegment expressionSegment) {
        return ExpressionConverter.convert(expressionSegment).orElseThrow(IllegalStateException::new);
    }
}

