/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.security.auth.Subject;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMixBinding {
    private final transient Logger LOG = LoggerFactory.getLogger(ServiceMixBinding.class);
    public static final String NMR_MESSAGE = "nmrMessage";
    public static final String NMR_EXCHANGE = "nmrExchange";
    public static final String NMR_OPERATION = "nmrOperation";

    public void copyCamelMessageToNmrMessage(Message nmrMessage, org.apache.camel.Message camelMessage) {
        if (nmrMessage != null && camelMessage != null) {
            nmrMessage.setBody(camelMessage.getBody());
            nmrMessage.getHeaders().clear();
            this.addNmrHeaders(nmrMessage, camelMessage);
            nmrMessage.getAttachments().clear();
            nmrMessage.getAttachments().putAll(camelMessage.getAttachments());
            if (camelMessage.getHeader("CamelAuthentication", Subject.class) != null) {
                nmrMessage.setSecuritySubject((Subject)camelMessage.getHeader("CamelAuthentication", Subject.class));
            }
        }
    }

    public void copyNmrMessageToCamelMessage(Message nmrMessage, org.apache.camel.Message camelMessage) {
        camelMessage.setBody(nmrMessage.getBody());
        camelMessage.setHeader(NMR_MESSAGE, (Object)nmrMessage);
        camelMessage.getHeaders().putAll(nmrMessage.getHeaders());
        this.addCamelAttachments(nmrMessage, camelMessage);
        if (nmrMessage.getSecuritySubject() != null) {
            camelMessage.setHeader("CamelAuthentication", (Object)nmrMessage.getSecuritySubject());
        }
    }

    public Exchange populateNmrExchangeFromCamelExchange(org.apache.camel.Exchange camelExchange, Channel client) {
        Exchange e = client.createExchange(Pattern.fromWsdlUri((String)camelExchange.getPattern().getWsdlUri()));
        e.getProperties().putAll(camelExchange.getProperties());
        Message inMessage = e.getIn();
        this.copyCamelMessageToNmrMessage(inMessage, camelExchange.getIn());
        return e;
    }

    public org.apache.camel.Exchange populateCamelExchangeFromNmrExchange(CamelContext context, Exchange nmrExchange) {
        DefaultExchange answer = new DefaultExchange(context);
        answer.setPattern(ExchangePattern.fromWsdlUri((String)nmrExchange.getPattern().getWsdlUri()));
        answer.getProperties().putAll(nmrExchange.getProperties());
        Message inMessage = nmrExchange.getIn();
        if (inMessage != null) {
            DefaultMessage message = new DefaultMessage();
            this.copyNmrMessageToCamelMessage(inMessage, (org.apache.camel.Message)message);
            answer.setIn((org.apache.camel.Message)message);
        }
        answer.setProperty(NMR_EXCHANGE, (Object)nmrExchange);
        if (nmrExchange != null && nmrExchange.getOperation() != null) {
            answer.setProperty(NMR_OPERATION, (Object)nmrExchange.getOperation().toString());
        }
        return answer;
    }

    protected void addNmrHeaders(Message nmrMessage, org.apache.camel.Message camelMessage) {
        Set entries = camelMessage.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            if (((String)entry.getKey()).equals(NMR_MESSAGE) || !(entry.getValue() instanceof Serializable) || entry.getValue() instanceof Map || entry.getValue() instanceof Collection) continue;
            nmrMessage.setHeader((String)entry.getKey(), entry.getValue());
        }
    }

    protected void addCamelAttachments(Message nmrMessage, org.apache.camel.Message camelMessage) {
        Set names = nmrMessage.getAttachments().keySet();
        for (String name : names) {
            if (nmrMessage.getAttachment(name) instanceof DataHandler) {
                DataHandler dataHandler = (DataHandler)nmrMessage.getAttachment(name);
                camelMessage.addAttachment(name, dataHandler);
                continue;
            }
            this.LOG.warn("NMR attachement of " + name + " is not a instance of DataHandler, cannot copy it into Camel message.");
        }
    }

    public Message getNmrMessage(org.apache.camel.Message message) {
        if (message.getHeader(NMR_MESSAGE) != null) {
            return (Message)message.getHeader(NMR_MESSAGE, Message.class);
        }
        return null;
    }

    public Exchange extractNmrExchange(org.apache.camel.Exchange camel) {
        return (Exchange)camel.getProperties().remove(NMR_EXCHANGE);
    }
}

