/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet10.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.CustomWindowState;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PortletInfo;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet10.impl.CustomPortletModeType;
import org.apache.pluto.container.om.portlet10.impl.CustomWindowStateType;
import org.apache.pluto.container.om.portlet10.impl.DescriptionType;
import org.apache.pluto.container.om.portlet10.impl.DisplayNameType;
import org.apache.pluto.container.om.portlet10.impl.InitParamType;
import org.apache.pluto.container.om.portlet10.impl.PortletInfoType;
import org.apache.pluto.container.om.portlet10.impl.PortletPreferencesType;
import org.apache.pluto.container.om.portlet10.impl.PortletType;
import org.apache.pluto.container.om.portlet10.impl.PreferenceType;
import org.apache.pluto.container.om.portlet10.impl.SecurityConstraintType;
import org.apache.pluto.container.om.portlet10.impl.SecurityRoleRefType;
import org.apache.pluto.container.om.portlet10.impl.SupportsType;
import org.apache.pluto.container.om.portlet10.impl.UserAttributeType;

@XmlRootElement(name="portlet-app")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="portlet-appType", propOrder={"portlet", "customPortletMode", "customWindowState", "userAttribute", "securityConstraint"})
public class PortletAppType {
    @XmlElement(name="portlet")
    List<PortletType> portlet;
    @XmlElement(name="custom-portlet-mode")
    List<CustomPortletModeType> customPortletMode;
    @XmlElement(name="custom-window-state")
    List<CustomWindowStateType> customWindowState;
    @XmlElement(name="user-attribute")
    List<UserAttributeType> userAttribute;
    @XmlElement(name="security-constraint")
    List<SecurityConstraintType> securityConstraint;
    @XmlAttribute(required=true)
    String version = "1.0";

    public PortletAppType() {
    }

    public PortletAppType(PortletApplicationDefinition app) {
        DescriptionType dt;
        for (PortletDefinition pd : app.getPortlets()) {
            if (this.portlet == null) {
                this.portlet = new ArrayList<PortletType>();
            }
            PortletType pt = new PortletType();
            this.downgradePortlet(pd, pt);
            this.portlet.add(pt);
        }
        for (CustomPortletMode cpm : app.getCustomPortletModes()) {
            if (this.customPortletMode == null) {
                this.customPortletMode = new ArrayList<CustomPortletModeType>();
            }
            CustomPortletModeType cpmt = new CustomPortletModeType();
            cpmt.portletMode = cpm.getPortletMode();
            for (Description d : cpm.getDescriptions()) {
                if (cpmt.description == null) {
                    cpmt.description = new ArrayList<DescriptionType>();
                }
                dt = new DescriptionType();
                dt.lang = d.getLang();
                dt.value = d.getDescription();
                cpmt.description.add(dt);
            }
        }
        for (CustomWindowState cws : app.getCustomWindowStates()) {
            if (this.customWindowState == null) {
                this.customWindowState = new ArrayList<CustomWindowStateType>();
            }
            CustomWindowStateType cwst = new CustomWindowStateType();
            cwst.windowState = cws.getWindowState();
            for (Description d : cws.getDescriptions()) {
                if (cwst.description == null) {
                    cwst.description = new ArrayList<DescriptionType>();
                }
                dt = new DescriptionType();
                dt.lang = d.getLang();
                dt.value = d.getDescription();
                cwst.description.add(dt);
            }
        }
    }

    public PortletApplicationDefinition upgrade() {
        Description desc;
        PortletDefinition target;
        org.apache.pluto.container.om.portlet.impl.PortletAppType app = new org.apache.pluto.container.om.portlet.impl.PortletAppType();
        app.setVersion(this.version);
        if (this.portlet != null) {
            for (PortletType portletType : this.portlet) {
                target = app.addPortlet(portletType.portletName);
                this.upgradePortlet(portletType, target);
            }
        }
        if (this.customPortletMode != null) {
            for (CustomPortletModeType customPortletModeType : this.customPortletMode) {
                target = app.addCustomPortletMode(customPortletModeType.portletMode);
                if (customPortletModeType.description == null) continue;
                for (DescriptionType descriptionType : customPortletModeType.description) {
                    desc = target.addDescription(descriptionType.lang);
                    desc.setDescription(descriptionType.value);
                }
            }
        }
        if (this.customWindowState != null) {
            for (CustomWindowStateType customWindowStateType : this.customWindowState) {
                target = app.addCustomWindowState(customWindowStateType.windowState);
                if (customWindowStateType.description == null) continue;
                for (DescriptionType descriptionType : customWindowStateType.description) {
                    desc = target.addDescription(descriptionType.lang);
                    desc.setDescription(descriptionType.value);
                }
            }
        }
        if (this.userAttribute != null) {
            for (UserAttributeType userAttributeType : this.userAttribute) {
                target = app.addUserAttribute(userAttributeType.name);
                if (userAttributeType.description == null) continue;
                for (DescriptionType descriptionType : userAttributeType.description) {
                    desc = target.addDescription(descriptionType.lang);
                    desc.setDescription(descriptionType.value);
                }
            }
        }
        if (this.securityConstraint != null) {
            for (SecurityConstraintType securityConstraintType : this.securityConstraint) {
                target = app.addSecurityConstraint(securityConstraintType.userDataConstraint.transportGuarantee);
                if (securityConstraintType.displayName != null) {
                    for (DisplayNameType displayNameType : securityConstraintType.displayName) {
                        DisplayName dname = target.addDisplayName(displayNameType.lang);
                        dname.setDisplayName(displayNameType.value);
                    }
                }
                if (securityConstraintType.portletCollection == null || securityConstraintType.portletCollection.portletName == null) continue;
                for (String string : securityConstraintType.portletCollection.portletName) {
                    target.addPortletName(string);
                }
            }
        }
        return app;
    }

    private void downgradePortlet(PortletDefinition src, PortletType target) {
        for (Description d : src.getDescriptions()) {
            if (target.description == null) {
                target.description = new ArrayList<DescriptionType>();
            }
            DescriptionType dt = new DescriptionType();
            dt.lang = d.getLang();
            dt.value = d.getDescription();
            target.description.add(dt);
        }
        for (Description d : src.getDisplayNames()) {
            if (target.displayName == null) {
                target.displayName = new ArrayList<DisplayNameType>();
            }
            DisplayNameType dnt = new DisplayNameType();
            dnt.lang = d.getLang();
            dnt.value = d.getDisplayName();
            target.displayName.add(dnt);
        }
        target.portletClass = src.getPortletClass();
        if (src.getExpirationCache() != 0) {
            target.expirationCache = new Integer(src.getExpirationCache());
        }
        for (InitParam p : src.getInitParams()) {
            if (target.initParam == null) {
                target.initParam = new ArrayList<InitParamType>();
            }
            InitParamType pt = new InitParamType();
            pt.name = p.getParamName();
            pt.value = p.getParamValue();
            for (Description d : p.getDescriptions()) {
                if (pt.description == null) {
                    pt.description = new ArrayList<DescriptionType>();
                }
                DescriptionType dt = new DescriptionType();
                dt.lang = d.getLang();
                dt.value = d.getDescription();
                pt.description.add(dt);
            }
            target.initParam.add(pt);
        }
        for (Supports s : src.getSupports()) {
            if (target.supports == null) {
                target.supports = new ArrayList<SupportsType>();
            }
            SupportsType st = new SupportsType();
            st.mimeType = s.getMimeType();
            for (String name : s.getPortletModes()) {
                if (st.portletMode == null) {
                    st.portletMode = new ArrayList<String>();
                }
                st.portletMode.add(name);
            }
            target.supports.add(st);
        }
        for (String lang : src.getSupportedLocales()) {
            if (target.supportedLocale == null) {
                target.supportedLocale = new ArrayList<String>();
            }
            target.supportedLocale.add(lang);
        }
        target.resourceBundle = src.getResourceBundle();
        PortletInfoType pit = new PortletInfoType();
        pit.title = src.getPortletInfo().getTitle();
        pit.shortTitle = src.getPortletInfo().getShortTitle();
        pit.keywords = src.getPortletInfo().getKeywords();
        if (pit.title != null || pit.shortTitle != null || pit.keywords != null) {
            target.portletInfo = pit;
        }
        PortletPreferencesType ppt = new PortletPreferencesType();
        ppt.preferencesValidator = src.getPortletPreferences().getPreferencesValidator();
        for (Preference p : src.getPortletPreferences().getPortletPreferences()) {
            if (ppt.preference == null) {
                ppt.preference = new ArrayList<PreferenceType>();
            }
            PreferenceType pt = new PreferenceType();
            pt.name = p.getName();
            pt.readOnly = p.isReadOnly() ? Boolean.TRUE : null;
            for (String value : p.getValues()) {
                if (pt.value == null) {
                    pt.value = new ArrayList<String>();
                }
                pt.value.add(value);
            }
            ppt.preference.add(pt);
        }
        if (ppt.preferencesValidator != null || ppt.preference != null) {
            target.portletPreferences = ppt;
        }
        for (SecurityRoleRef srr : src.getSecurityRoleRefs()) {
            if (target.securityRoleRef == null) {
                target.securityRoleRef = new ArrayList<SecurityRoleRefType>();
            }
            SecurityRoleRefType srrt = new SecurityRoleRefType();
            srrt.roleName = srr.getRoleName();
            srrt.roleLink = srr.getRoleLink();
            for (Description d : srr.getDescriptions()) {
                if (srrt.description == null) {
                    srrt.description = new ArrayList<DescriptionType>();
                }
                DescriptionType dt = new DescriptionType();
                dt.lang = d.getLang();
                dt.value = d.getDescription();
                srrt.description.add(dt);
            }
            target.securityRoleRef.add(srrt);
        }
    }

    private void upgradePortlet(PortletType src, PortletDefinition target) {
        Description desc;
        if (src.description != null) {
            for (DescriptionType descriptionType : src.description) {
                Description desc2 = target.addDescription(descriptionType.lang);
                desc2.setDescription(descriptionType.value);
            }
        }
        if (src.displayName != null) {
            for (DisplayNameType displayNameType : src.displayName) {
                DisplayName dname = target.addDisplayName(displayNameType.lang);
                dname.setDisplayName(displayNameType.value);
            }
        }
        target.setPortletClass(src.portletClass);
        if (src.expirationCache != null) {
            target.setExpirationCache(src.expirationCache.intValue());
        }
        if (src.initParam != null) {
            for (InitParamType initParamType : src.initParam) {
                InitParam param = target.addInitParam(initParamType.name);
                param.setParamValue(initParamType.value);
                if (initParamType.description == null) continue;
                for (DescriptionType d : initParamType.description) {
                    desc = param.addDescription(d.lang);
                    desc.setDescription(d.value);
                }
            }
        }
        if (src.supports != null) {
            for (SupportsType supportsType : src.supports) {
                Supports s = target.addSupports(supportsType.mimeType);
                if (supportsType.portletMode == null) continue;
                for (String mode : supportsType.portletMode) {
                    s.addPortletMode(mode);
                }
            }
        }
        if (src.supportedLocale != null) {
            for (String string : src.supportedLocale) {
                target.addSupportedLocale(string);
            }
        }
        target.setResourceBundle(src.resourceBundle);
        if (src.portletInfo != null) {
            PortletInfo pi = target.getPortletInfo();
            pi.setTitle(src.portletInfo.title);
            pi.setShortTitle(src.portletInfo.shortTitle);
            pi.setKeywords(src.portletInfo.keywords);
        }
        if (src.portletPreferences != null) {
            Preferences prefs = target.getPortletPreferences();
            prefs.setPreferencesValidator(src.portletPreferences.preferencesValidator);
            if (src.portletPreferences.preference != null) {
                for (PreferenceType p : src.portletPreferences.preference) {
                    Preference pref = prefs.addPreference(p.name);
                    if (p.value != null) {
                        for (String value : p.value) {
                            pref.addValue(value);
                        }
                    }
                    if (p.readOnly == null) continue;
                    pref.setReadOnly(p.readOnly.booleanValue());
                }
            }
        }
        if (src.securityRoleRef != null) {
            for (SecurityRoleRefType securityRoleRefType : src.securityRoleRef) {
                SecurityRoleRef srr = target.addSecurityRoleRef(securityRoleRefType.roleName);
                srr.setRoleLink(securityRoleRefType.roleLink);
                if (securityRoleRefType.description == null) continue;
                for (DescriptionType d : securityRoleRefType.description) {
                    desc = srr.addDescription(d.lang);
                    desc.setDescription(d.value);
                }
            }
        }
    }
}

