/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.sl.draw.geom.CustomGeometry;
import org.apache.poi.sl.draw.geom.Guide;
import org.apache.poi.sl.draw.geom.PresetGeometries;
import org.apache.poi.sl.usermodel.FillStyle;
import org.apache.poi.sl.usermodel.LineDecoration;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.Placeholder;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.StrokeStyle;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.model.PropertyFetcher;
import org.apache.poi.xslf.usermodel.XSLFHyperlink;
import org.apache.poi.xslf.usermodel.XSLFShadow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBaseStyles;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTEffectStyleItem;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineEndProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTLineStyleList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOuterShadowEffect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetLineDashProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrix;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STCompoundLine;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineCap;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndLength;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndType;
import org.openxmlformats.schemas.drawingml.x2006.main.STLineEndWidth;
import org.openxmlformats.schemas.drawingml.x2006.main.STPresetLineDashVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

public abstract class XSLFSimpleShape
extends XSLFShape
implements SimpleShape<XSLFShape, XSLFTextParagraph> {
    private static CTOuterShadowEffect NO_SHADOW = CTOuterShadowEffect.Factory.newInstance();

    XSLFSimpleShape(XmlObject shape, XSLFSheet sheet) {
        super(shape, sheet);
    }

    public void setShapeType(ShapeType type) {
        STShapeType.Enum geom = STShapeType.Enum.forInt((int)type.ooxmlId);
        this.getSpPr().getPrstGeom().setPrst(geom);
    }

    public ShapeType getShapeType() {
        STShapeType.Enum geom = this.getSpPr().getPrstGeom().getPrst();
        return ShapeType.forId((int)geom.intValue(), (boolean)true);
    }

    protected CTTransform2D getSafeXfrm() {
        CTTransform2D xfrm = this.getXfrm();
        return xfrm == null ? this.getSpPr().addNewXfrm() : xfrm;
    }

    protected CTTransform2D getXfrm() {
        PropertyFetcher<CTTransform2D> fetcher = new PropertyFetcher<CTTransform2D>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                CTShapeProperties pr = shape.getSpPr();
                if (pr.isSetXfrm()) {
                    this.setValue(pr.getXfrm());
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return (CTTransform2D)fetcher.getValue();
    }

    public Rectangle2D getAnchor() {
        CTTransform2D xfrm = this.getXfrm();
        CTPoint2D off = xfrm.getOff();
        double x = Units.toPoints((long)off.getX());
        double y = Units.toPoints((long)off.getY());
        CTPositiveSize2D ext = xfrm.getExt();
        double cx = Units.toPoints((long)ext.getCx());
        double cy = Units.toPoints((long)ext.getCy());
        return new Rectangle2D.Double(x, y, cx, cy);
    }

    public void setAnchor(Rectangle2D anchor) {
        CTTransform2D xfrm = this.getSafeXfrm();
        CTPoint2D off = xfrm.isSetOff() ? xfrm.getOff() : xfrm.addNewOff();
        long x = Units.toEMU((double)anchor.getX());
        long y = Units.toEMU((double)anchor.getY());
        off.setX(x);
        off.setY(y);
        CTPositiveSize2D ext = xfrm.isSetExt() ? xfrm.getExt() : xfrm.addNewExt();
        long cx = Units.toEMU((double)anchor.getWidth());
        long cy = Units.toEMU((double)anchor.getHeight());
        ext.setCx(cx);
        ext.setCy(cy);
    }

    public void setRotation(double theta) {
        this.getSafeXfrm().setRot((int)(theta * 60000.0));
    }

    public double getRotation() {
        CTTransform2D xfrm = this.getXfrm();
        return xfrm == null || !xfrm.isSetRot() ? 0.0 : (double)xfrm.getRot() / 60000.0;
    }

    public void setFlipHorizontal(boolean flip) {
        this.getSafeXfrm().setFlipH(flip);
    }

    public void setFlipVertical(boolean flip) {
        this.getSafeXfrm().setFlipV(flip);
    }

    public boolean getFlipHorizontal() {
        CTTransform2D xfrm = this.getXfrm();
        return xfrm == null || !xfrm.isSetFlipH() ? false : this.getXfrm().getFlipH();
    }

    public boolean getFlipVertical() {
        CTTransform2D xfrm = this.getXfrm();
        return xfrm == null || !xfrm.isSetFlipV() ? false : this.getXfrm().getFlipV();
    }

    CTLineProperties getDefaultLineProperties() {
        CTShapeStyle style = this.getSpStyle();
        if (style == null) {
            return null;
        }
        CTStyleMatrixReference lnRef = style.getLnRef();
        if (lnRef == null) {
            return null;
        }
        int idx = (int)lnRef.getIdx();
        XSLFTheme theme = this.getSheet().getTheme();
        if (theme == null) {
            return null;
        }
        CTBaseStyles styles = theme.getXmlObject().getThemeElements();
        if (styles == null) {
            return null;
        }
        CTStyleMatrix styleMatrix = styles.getFmtScheme();
        if (styleMatrix == null) {
            return null;
        }
        CTLineStyleList lineStyles = styleMatrix.getLnStyleLst();
        if (lineStyles == null || lineStyles.sizeOfLnArray() < idx) {
            return null;
        }
        return lineStyles.getLnArray(idx - 1);
    }

    public void setLineColor(Color color) {
        CTShapeProperties spPr = this.getSpPr();
        if (color == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetSolidFill()) {
                spPr.getLn().unsetSolidFill();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            CTSolidColorFillProperties fill = ln.isSetSolidFill() ? ln.getSolidFill() : ln.addNewSolidFill();
            fill.setSrgbClr(rgb);
            if (fill.isSetHslClr()) {
                fill.unsetHslClr();
            }
            if (fill.isSetPrstClr()) {
                fill.unsetPrstClr();
            }
            if (fill.isSetSchemeClr()) {
                fill.unsetSchemeClr();
            }
            if (fill.isSetScrgbClr()) {
                fill.unsetScrgbClr();
            }
            if (fill.isSetSysClr()) {
                fill.unsetSysClr();
            }
        }
    }

    public Color getLineColor() {
        PaintStyle ps = this.getLinePaint();
        if (ps instanceof PaintStyle.SolidPaint) {
            return ((PaintStyle.SolidPaint)ps).getSolidColor().getColor();
        }
        return null;
    }

    protected PaintStyle getLinePaint() {
        PropertyFetcher<PaintStyle> fetcher = new PropertyFetcher<PaintStyle>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                CTLineProperties spPr = shape.getSpPr().getLn();
                if (spPr != null) {
                    if (spPr.isSetNoFill()) {
                        this.setValue(null);
                        return true;
                    }
                    PaintStyle paint = null;
                    PackagePart pp = XSLFSimpleShape.this.getSheet().getPackagePart();
                    for (XmlObject obj : spPr.selectPath("*")) {
                        paint = XSLFSimpleShape.this.selectPaint(obj, null, pp);
                        if (paint == null) continue;
                        this.setValue(paint);
                        return true;
                    }
                    CTShapeStyle style = shape.getSpStyle();
                    if (style != null && (paint = XSLFSimpleShape.this.selectPaint(style.getLnRef())) != null) {
                        this.setValue(paint);
                        return true;
                    }
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        PaintStyle paint = (PaintStyle)fetcher.getValue();
        if (paint != null) {
            return paint;
        }
        CTShapeStyle style = this.getSpStyle();
        if (style == null) {
            return null;
        }
        CTStyleMatrixReference lnRef = style.getLnRef();
        int idx = (int)lnRef.getIdx();
        CTSchemeColor phClr = lnRef.getSchemeClr();
        if (idx > 0) {
            XSLFTheme theme = this.getSheet().getTheme();
            XmlObject lnProps = theme.getXmlObject().getThemeElements().getFmtScheme().getLnStyleLst().selectPath("*")[idx - 1];
            paint = this.getPaint(lnProps, phClr);
        }
        return paint;
    }

    public void setLineWidth(double width) {
        CTShapeProperties spPr = this.getSpPr();
        if (width == 0.0) {
            if (spPr.isSetLn() && spPr.getLn().isSetW()) {
                spPr.getLn().unsetW();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setW(Units.toEMU((double)width));
        }
    }

    public double getLineWidth() {
        PropertyFetcher<Double> fetcher = new PropertyFetcher<Double>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                CTShapeProperties spPr = shape.getSpPr();
                CTLineProperties ln = spPr.getLn();
                if (ln != null) {
                    if (ln.isSetNoFill()) {
                        this.setValue(0.0);
                        return true;
                    }
                    if (ln.isSetW()) {
                        this.setValue(Units.toPoints((long)ln.getW()));
                        return true;
                    }
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        double lineWidth = 0.0;
        if (fetcher.getValue() == null) {
            CTLineProperties defaultLn = this.getDefaultLineProperties();
            if (defaultLn != null && defaultLn.isSetW()) {
                lineWidth = Units.toPoints((long)defaultLn.getW());
            }
        } else {
            lineWidth = (Double)fetcher.getValue();
        }
        return lineWidth;
    }

    public void setLineCompound(StrokeStyle.LineCompound compound) {
        CTShapeProperties spPr = this.getSpPr();
        if (compound == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetCmpd()) {
                spPr.getLn().unsetCmpd();
            }
        } else {
            STCompoundLine.Enum xCmpd;
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            switch (compound) {
                default: {
                    xCmpd = STCompoundLine.SNG;
                    break;
                }
                case DOUBLE: {
                    xCmpd = STCompoundLine.DBL;
                    break;
                }
                case THICK_THIN: {
                    xCmpd = STCompoundLine.THICK_THIN;
                    break;
                }
                case THIN_THICK: {
                    xCmpd = STCompoundLine.THIN_THICK;
                    break;
                }
                case TRIPLE: {
                    xCmpd = STCompoundLine.TRI;
                }
            }
            ln.setCmpd(xCmpd);
        }
    }

    public StrokeStyle.LineCompound getLineCompound() {
        STCompoundLine.Enum stCmpd;
        CTLineProperties defaultLn;
        PropertyFetcher<Integer> fetcher = new PropertyFetcher<Integer>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                STCompoundLine.Enum stCmpd;
                CTShapeProperties spPr = shape.getSpPr();
                CTLineProperties ln = spPr.getLn();
                if (ln != null && (stCmpd = ln.getCmpd()) != null) {
                    this.setValue(stCmpd.intValue());
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        Integer cmpd = (Integer)fetcher.getValue();
        if (cmpd == null && (defaultLn = this.getDefaultLineProperties()) != null && (stCmpd = defaultLn.getCmpd()) != null) {
            cmpd = stCmpd.intValue();
        }
        if (cmpd == null) {
            return null;
        }
        switch (cmpd) {
            default: {
                return StrokeStyle.LineCompound.SINGLE;
            }
            case 2: {
                return StrokeStyle.LineCompound.DOUBLE;
            }
            case 3: {
                return StrokeStyle.LineCompound.THICK_THIN;
            }
            case 4: {
                return StrokeStyle.LineCompound.THIN_THICK;
            }
            case 5: 
        }
        return StrokeStyle.LineCompound.TRIPLE;
    }

    public void setLineDash(StrokeStyle.LineDash dash) {
        CTShapeProperties spPr = this.getSpPr();
        if (dash == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetPrstDash()) {
                spPr.getLn().unsetPrstDash();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            CTPresetLineDashProperties ldp = ln.isSetPrstDash() ? ln.getPrstDash() : ln.addNewPrstDash();
            ldp.setVal(STPresetLineDashVal.Enum.forInt((int)dash.ooxmlId));
        }
    }

    public StrokeStyle.LineDash getLineDash() {
        CTPresetLineDashProperties ctDash;
        CTLineProperties defaultLn;
        PropertyFetcher<StrokeStyle.LineDash> fetcher = new PropertyFetcher<StrokeStyle.LineDash>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                CTPresetLineDashProperties ctDash;
                CTShapeProperties spPr = shape.getSpPr();
                CTLineProperties ln = spPr.getLn();
                if (ln != null && (ctDash = ln.getPrstDash()) != null) {
                    this.setValue(StrokeStyle.LineDash.fromOoxmlId((int)ctDash.getVal().intValue()));
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        StrokeStyle.LineDash dash = (StrokeStyle.LineDash)fetcher.getValue();
        if (dash == null && (defaultLn = this.getDefaultLineProperties()) != null && (ctDash = defaultLn.getPrstDash()) != null) {
            dash = StrokeStyle.LineDash.fromOoxmlId((int)ctDash.getVal().intValue());
        }
        return dash;
    }

    public void setLineCap(StrokeStyle.LineCap cap) {
        CTShapeProperties spPr = this.getSpPr();
        if (cap == null) {
            if (spPr.isSetLn() && spPr.getLn().isSetCap()) {
                spPr.getLn().unsetCap();
            }
        } else {
            CTLineProperties ln = spPr.isSetLn() ? spPr.getLn() : spPr.addNewLn();
            ln.setCap(STLineCap.Enum.forInt((int)cap.ooxmlId));
        }
    }

    public StrokeStyle.LineCap getLineCap() {
        STLineCap.Enum stCap;
        CTLineProperties defaultLn;
        PropertyFetcher<StrokeStyle.LineCap> fetcher = new PropertyFetcher<StrokeStyle.LineCap>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                STLineCap.Enum stCap;
                CTShapeProperties spPr = shape.getSpPr();
                CTLineProperties ln = spPr.getLn();
                if (ln != null && (stCap = ln.getCap()) != null) {
                    this.setValue(StrokeStyle.LineCap.fromOoxmlId((int)stCap.intValue()));
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        StrokeStyle.LineCap cap = (StrokeStyle.LineCap)fetcher.getValue();
        if (cap == null && (defaultLn = this.getDefaultLineProperties()) != null && (stCap = defaultLn.getCap()) != null) {
            cap = StrokeStyle.LineCap.fromOoxmlId((int)stCap.intValue());
        }
        return cap;
    }

    public void setFillColor(Color color) {
        CTShapeProperties spPr = this.getSpPr();
        if (color == null) {
            if (spPr.isSetSolidFill()) {
                spPr.unsetSolidFill();
            }
            if (!spPr.isSetNoFill()) {
                spPr.addNewNoFill();
            }
        } else {
            if (spPr.isSetNoFill()) {
                spPr.unsetNoFill();
            }
            CTSolidColorFillProperties fill = spPr.isSetSolidFill() ? spPr.getSolidFill() : spPr.addNewSolidFill();
            CTSRgbColor rgb = CTSRgbColor.Factory.newInstance();
            rgb.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
            fill.setSrgbClr(rgb);
            if (fill.isSetHslClr()) {
                fill.unsetHslClr();
            }
            if (fill.isSetPrstClr()) {
                fill.unsetPrstClr();
            }
            if (fill.isSetSchemeClr()) {
                fill.unsetSchemeClr();
            }
            if (fill.isSetScrgbClr()) {
                fill.unsetScrgbClr();
            }
            if (fill.isSetSysClr()) {
                fill.unsetSysClr();
            }
        }
    }

    public Color getFillColor() {
        PaintStyle ps = this.getFillPaint();
        if (ps instanceof PaintStyle.SolidPaint) {
            return ((PaintStyle.SolidPaint)ps).getSolidColor().getColor();
        }
        return null;
    }

    public XSLFShadow getShadow() {
        int idx;
        CTShapeStyle style;
        PropertyFetcher<CTOuterShadowEffect> fetcher = new PropertyFetcher<CTOuterShadowEffect>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                CTShapeProperties spPr = shape.getSpPr();
                if (spPr.isSetEffectLst()) {
                    CTOuterShadowEffect obj = spPr.getEffectLst().getOuterShdw();
                    this.setValue(obj == null ? NO_SHADOW : obj);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        CTOuterShadowEffect obj = (CTOuterShadowEffect)fetcher.getValue();
        if (obj == null && (style = this.getSpStyle()) != null && (idx = (int)style.getEffectRef().getIdx()) != 0) {
            CTStyleMatrix styleMatrix = this.getSheet().getTheme().getXmlObject().getThemeElements().getFmtScheme();
            CTEffectStyleItem ef = styleMatrix.getEffectStyleLst().getEffectStyleArray(idx - 1);
            obj = ef.getEffectLst().getOuterShdw();
        }
        return obj == null || obj == NO_SHADOW ? null : new XSLFShadow(obj, this);
    }

    public CustomGeometry getGeometry() {
        CustomGeometry geom;
        CTShapeProperties spPr = this.getSpPr();
        PresetGeometries dict = PresetGeometries.getInstance();
        if (spPr.isSetPrstGeom()) {
            String name = spPr.getPrstGeom().getPrst().toString();
            geom = (CustomGeometry)dict.get((Object)name);
            if (geom == null) {
                throw new IllegalStateException("Unknown shape geometry: " + name + ", available geometries are: " + dict.keySet());
            }
        } else if (spPr.isSetCustGeom()) {
            XMLStreamReader staxReader = spPr.getCustGeom().newXMLStreamReader();
            geom = PresetGeometries.convertCustomGeometry((XMLStreamReader)staxReader);
            try {
                staxReader.close();
            }
            catch (XMLStreamException e) {}
        } else {
            geom = (CustomGeometry)dict.get((Object)"rect");
        }
        return geom;
    }

    @Override
    void copy(XSLFShape sh) {
        double tgtLineWidth;
        double srcLineWidth;
        super.copy(sh);
        XSLFSimpleShape s = (XSLFSimpleShape)sh;
        Color srsSolidFill = s.getFillColor();
        Color tgtSoliFill = this.getFillColor();
        if (srsSolidFill != null && !srsSolidFill.equals(tgtSoliFill)) {
            this.setFillColor(srsSolidFill);
        }
        if (this.getSpPr().isSetBlipFill()) {
            CTBlip blip = this.getSpPr().getBlipFill().getBlip();
            String blipId = blip.getEmbed();
            String relId = this.getSheet().importBlip(blipId, s.getSheet().getPackagePart());
            blip.setEmbed(relId);
        }
        Color srcLineColor = s.getLineColor();
        Color tgtLineColor = this.getLineColor();
        if (srcLineColor != null && !srcLineColor.equals(tgtLineColor)) {
            this.setLineColor(srcLineColor);
        }
        if ((srcLineWidth = s.getLineWidth()) != (tgtLineWidth = this.getLineWidth())) {
            this.setLineWidth(srcLineWidth);
        }
        StrokeStyle.LineDash srcLineDash = s.getLineDash();
        StrokeStyle.LineDash tgtLineDash = this.getLineDash();
        if (srcLineDash != null && srcLineDash != tgtLineDash) {
            this.setLineDash(srcLineDash);
        }
        StrokeStyle.LineCap srcLineCap = s.getLineCap();
        StrokeStyle.LineCap tgtLineCap = this.getLineCap();
        if (srcLineCap != null && srcLineCap != tgtLineCap) {
            this.setLineCap(srcLineCap);
        }
    }

    public void setLineHeadDecoration(LineDecoration.DecorationShape style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetType()) {
                lnEnd.unsetType();
            }
        } else {
            lnEnd.setType(STLineEndType.Enum.forInt((int)style.ooxmlId));
        }
    }

    public LineDecoration.DecorationShape getLineHeadDecoration() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetHeadEnd()) {
            return LineDecoration.DecorationShape.NONE;
        }
        STLineEndType.Enum end = ln.getHeadEnd().getType();
        return end == null ? LineDecoration.DecorationShape.NONE : LineDecoration.DecorationShape.fromOoxmlId((int)end.intValue());
    }

    public void setLineHeadWidth(LineDecoration.DecorationSize style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetW()) {
                lnEnd.unsetW();
            }
        } else {
            lnEnd.setW(STLineEndWidth.Enum.forInt((int)style.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineHeadWidth() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetHeadEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndWidth.Enum w = ln.getHeadEnd().getW();
        return w == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId((int)w.intValue());
    }

    public void setLineHeadLength(LineDecoration.DecorationSize style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetHeadEnd() ? ln.getHeadEnd() : ln.addNewHeadEnd();
        if (style == null) {
            if (lnEnd.isSetLen()) {
                lnEnd.unsetLen();
            }
        } else {
            lnEnd.setLen(STLineEndLength.Enum.forInt((int)style.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineHeadLength() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetHeadEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndLength.Enum len = ln.getHeadEnd().getLen();
        return len == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId((int)len.intValue());
    }

    public void setLineTailDecoration(LineDecoration.DecorationShape style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetType()) {
                lnEnd.unsetType();
            }
        } else {
            lnEnd.setType(STLineEndType.Enum.forInt((int)style.ooxmlId));
        }
    }

    public LineDecoration.DecorationShape getLineTailDecoration() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetTailEnd()) {
            return LineDecoration.DecorationShape.NONE;
        }
        STLineEndType.Enum end = ln.getTailEnd().getType();
        return end == null ? LineDecoration.DecorationShape.NONE : LineDecoration.DecorationShape.fromOoxmlId((int)end.intValue());
    }

    public void setLineTailWidth(LineDecoration.DecorationSize style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetW()) {
                lnEnd.unsetW();
            }
        } else {
            lnEnd.setW(STLineEndWidth.Enum.forInt((int)style.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineTailWidth() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetTailEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndWidth.Enum w = ln.getTailEnd().getW();
        return w == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId((int)w.intValue());
    }

    public void setLineTailLength(LineDecoration.DecorationSize style) {
        CTLineEndProperties lnEnd;
        CTLineProperties ln = this.getSpPr().getLn();
        CTLineEndProperties cTLineEndProperties = lnEnd = ln.isSetTailEnd() ? ln.getTailEnd() : ln.addNewTailEnd();
        if (style == null) {
            if (lnEnd.isSetLen()) {
                lnEnd.unsetLen();
            }
        } else {
            lnEnd.setLen(STLineEndLength.Enum.forInt((int)style.ooxmlId));
        }
    }

    public LineDecoration.DecorationSize getLineTailLength() {
        CTLineProperties ln = this.getSpPr().getLn();
        if (ln == null || !ln.isSetTailEnd()) {
            return LineDecoration.DecorationSize.MEDIUM;
        }
        STLineEndLength.Enum len = ln.getTailEnd().getLen();
        return len == null ? LineDecoration.DecorationSize.MEDIUM : LineDecoration.DecorationSize.fromOoxmlId((int)len.intValue());
    }

    public boolean isPlaceholder() {
        CTPlaceholder ph = this.getCTPlaceholder();
        return ph != null;
    }

    public Guide getAdjustValue(String name) {
        CTPresetGeometry2D prst = this.getSpPr().getPrstGeom();
        if (prst.isSetAvLst()) {
            for (CTGeomGuide g : prst.getAvLst().getGdArray()) {
                if (!g.getName().equals(name)) continue;
                return new Guide(g.getName(), g.getFmla());
            }
        }
        return null;
    }

    public LineDecoration getLineDecoration() {
        return new LineDecoration(){

            public LineDecoration.DecorationShape getHeadShape() {
                return XSLFSimpleShape.this.getLineHeadDecoration();
            }

            public LineDecoration.DecorationSize getHeadWidth() {
                return XSLFSimpleShape.this.getLineHeadWidth();
            }

            public LineDecoration.DecorationSize getHeadLength() {
                return XSLFSimpleShape.this.getLineHeadLength();
            }

            public LineDecoration.DecorationShape getTailShape() {
                return XSLFSimpleShape.this.getLineTailDecoration();
            }

            public LineDecoration.DecorationSize getTailWidth() {
                return XSLFSimpleShape.this.getLineTailWidth();
            }

            public LineDecoration.DecorationSize getTailLength() {
                return XSLFSimpleShape.this.getLineTailLength();
            }
        };
    }

    public FillStyle getFillStyle() {
        return new FillStyle(){

            public PaintStyle getPaint() {
                return XSLFSimpleShape.this.getFillPaint();
            }
        };
    }

    public StrokeStyle getStrokeStyle() {
        return new StrokeStyle(){

            public PaintStyle getPaint() {
                return XSLFSimpleShape.this.getLinePaint();
            }

            public StrokeStyle.LineCap getLineCap() {
                return XSLFSimpleShape.this.getLineCap();
            }

            public StrokeStyle.LineDash getLineDash() {
                return XSLFSimpleShape.this.getLineDash();
            }

            public double getLineWidth() {
                return XSLFSimpleShape.this.getLineWidth();
            }

            public StrokeStyle.LineCompound getLineCompound() {
                return XSLFSimpleShape.this.getLineCompound();
            }
        };
    }

    public void setStrokeStyle(Object ... styles) {
        if (styles.length == 0) {
            this.setLineColor(null);
            return;
        }
        for (Object st : styles) {
            if (st instanceof Number) {
                this.setLineWidth(((Number)st).doubleValue());
                continue;
            }
            if (st instanceof StrokeStyle.LineCap) {
                this.setLineCap((StrokeStyle.LineCap)st);
                continue;
            }
            if (st instanceof StrokeStyle.LineDash) {
                this.setLineDash((StrokeStyle.LineDash)st);
                continue;
            }
            if (st instanceof StrokeStyle.LineCompound) {
                this.setLineCompound((StrokeStyle.LineCompound)st);
                continue;
            }
            if (!(st instanceof Color)) continue;
            this.setLineColor((Color)st);
        }
    }

    @Override
    public void setPlaceholder(Placeholder placeholder) {
        super.setPlaceholder(placeholder);
    }

    public XSLFHyperlink getHyperlink() {
        CTNonVisualDrawingProps cNvPr = this.getCNvPr();
        if (!cNvPr.isSetHlinkClick()) {
            return null;
        }
        return new XSLFHyperlink(cNvPr.getHlinkClick(), this.getSheet());
    }

    public XSLFHyperlink createHyperlink() {
        XSLFHyperlink hl = this.getHyperlink();
        if (hl == null) {
            CTNonVisualDrawingProps cNvPr = this.getCNvPr();
            hl = new XSLFHyperlink(cNvPr.addNewHlinkClick(), this.getSheet());
        }
        return hl;
    }
}

