/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.poi.util.IOUtils;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public final class OOXMLLite {
    private static final Field _classes;
    private File _destDest;
    private File _testDir;
    private File _ooxmlJar;

    OOXMLLite(String dest, String test, String ooxmlJar) {
        this._destDest = new File(dest);
        this._testDir = new File(test);
        this._ooxmlJar = new File(ooxmlJar);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String dest = null;
        String test = null;
        String ooxml = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-dest")) {
                dest = args[++i];
                continue;
            }
            if (args[i].equals("-test")) {
                test = args[++i];
                continue;
            }
            if (!args[i].equals("-ooxml")) continue;
            ooxml = args[++i];
        }
        OOXMLLite builder = new OOXMLLite(dest, test, ooxml);
        builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build() throws IOException, ClassNotFoundException {
        File destFile;
        ArrayList lst = new ArrayList();
        System.out.println("Collecting unit tests from " + this._testDir);
        OOXMLLite.collectTests(this._testDir, this._testDir, lst, ".+.class$", ".+(TestUnfixedBugs|MemoryUsage|TestDataProvider|TestDataSamples|All.+Tests|ZipFileAssert|PkiTestUtils|TestCellFormatPart\\$\\d|TestSignatureInfo\\$\\d).class");
        System.out.println("Found " + lst.size() + " classes");
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener((RunListener)new TextListener(System.out));
        Result result = jUnitCore.run(lst.toArray(new Class[lst.size()]));
        if (!result.wasSuccessful()) {
            throw new RuntimeException("Tests did not succeed, cannot build ooxml-lite jar");
        }
        System.out.println("Copying classes to " + this._destDest);
        Map<String, Class<?>> classes = OOXMLLite.getLoadedClasses(this._ooxmlJar.getName());
        for (Class<?> cls : classes.values()) {
            String className = cls.getName();
            String classRef = className.replace('.', '/') + ".class";
            destFile = new File(this._destDest, classRef);
            OOXMLLite.copyFile(cls.getResourceAsStream('/' + classRef), destFile);
            if (!cls.isInterface()) continue;
            for (Class<?> fc : cls.getDeclaredClasses()) {
                className = fc.getName();
                classRef = className.replace('.', '/') + ".class";
                destFile = new File(this._destDest, classRef);
                OOXMLLite.copyFile(fc.getResourceAsStream('/' + classRef), destFile);
            }
        }
        System.out.println("Copying .xsb resources");
        JarFile jar = new JarFile(this._ooxmlJar);
        Pattern p = Pattern.compile("schemaorg_apache_xmlbeans/(system|element)/.*\\.xsb");
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (!p.matcher(je.getName()).matches()) continue;
                destFile = new File(this._destDest, je.getName());
                OOXMLLite.copyFile(jar.getInputStream(je), destFile);
            }
        }
        finally {
            jar.close();
        }
    }

    private static boolean checkForTestAnnotation(Class<?> testclass) {
        for (Method m : testclass.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        System.out.println("Class " + testclass.getName() + " does not derive from TestCase and does not have a @Test annotation");
        return false;
    }

    private static void collectTests(File root, File arg, List<Class<?>> out, String ptrn, String exclude) throws ClassNotFoundException {
        if (arg.isDirectory()) {
            for (File f : arg.listFiles()) {
                OOXMLLite.collectTests(root, f, out, ptrn, exclude);
            }
        } else {
            String prefix;
            String path = arg.getAbsolutePath();
            String cls = path.substring((prefix = root.getAbsolutePath()).length() + 1).replace(File.separator, ".");
            if (!cls.matches(ptrn)) {
                return;
            }
            if (cls.matches(exclude)) {
                return;
            }
            if (cls.indexOf(36) != -1) {
                System.out.println("Inner class " + cls + " not included");
                return;
            }
            Class<?> testclass = Class.forName(cls = cls.replace(".class", ""));
            if (TestCase.class.isAssignableFrom(testclass) || OOXMLLite.checkForTestAnnotation(testclass)) {
                out.add(testclass);
            }
        }
    }

    private static Map<String, Class<?>> getLoadedClasses(String ptrn) {
        ClassLoader appLoader = ClassLoader.getSystemClassLoader();
        try {
            Vector classes = (Vector)_classes.get(appLoader);
            HashMap map = new HashMap();
            for (Class cls : classes) {
                String jar;
                if (cls.getProtectionDomain() == null || cls.getProtectionDomain().getCodeSource() == null || (jar = cls.getProtectionDomain().getCodeSource().getLocation().toString()).indexOf(ptrn) == -1) continue;
                map.put(cls.getName(), cls);
            }
            return map;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream srcStream, File destFile) throws IOException {
        File destDirectory = destFile.getParentFile();
        destDirectory.mkdirs();
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            IOUtils.copy((InputStream)srcStream, (OutputStream)destStream);
        }
        finally {
            ((OutputStream)destStream).close();
        }
    }

    static {
        try {
            _classes = ClassLoader.class.getDeclaredField("classes");
            _classes.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

