/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.scanner;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.webbeans.corespi.scanner.AbstractMetaDataDiscovery;
import org.apache.webbeans.corespi.scanner.AnnotationDB;
import org.apache.webbeans.corespi.se.BeansXmlAnnotationDB;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.WebBeansUtil;
import org.scannotation.WarUrlFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebScannerService
extends AbstractMetaDataDiscovery {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(WebScannerService.class);
    private boolean configure = false;
    protected ServletContext servletContext = null;

    public void init(Object context) {
        super.init(context);
        this.servletContext = (ServletContext)context;
    }

    protected void configure() {
        try {
            if (!this.configure) {
                Set<String> arcs = this.getArchives();
                String[] urls = new String[arcs.size()];
                urls = arcs.toArray(urls);
                this.getAnnotationDB().scanArchives(urls);
                this.configure = true;
            }
        }
        catch (Exception e) {
            throw new WebBeansConfigurationException(this.logger.getTokenString("ERROR_0002"), (Throwable)e);
        }
    }

    private Set<String> getArchives() throws Exception {
        Set<String> lists = this.createURLFromMarkerFile();
        String warUrlPath = this.createURLFromWARFile();
        if (warUrlPath != null) {
            lists.add(warUrlPath);
        }
        return lists;
    }

    protected Set<String> createURLFromMarkerFile() throws Exception {
        HashSet<String> listURL = new HashSet<String>();
        ClassLoader parentClassLoader = WebBeansUtil.getCurrentClassLoader().getParent();
        String[] urls = this.findBeansXmlBases("META-INF/beans.xml", WebBeansUtil.getCurrentClassLoader());
        if (urls != null) {
            for (String url : urls) {
                String addPath;
                String fileDir = new URL(url).getFile();
                if (fileDir.endsWith(".jar!/")) {
                    if (!(fileDir = fileDir.substring(0, fileDir.lastIndexOf("/")) + "/" + "META-INF/beans.xml").startsWith("file:/")) {
                        fileDir = "file:/" + fileDir;
                    }
                    if (this.logger.wblWillLogDebug()) {
                        this.logger.debug("OpenWebBeans found the following url while doing web scanning: " + fileDir);
                    }
                    addPath = "jar:" + fileDir;
                    if (this.logger.wblWillLogDebug()) {
                        this.logger.debug("OpenWebBeans added the following jar based path while doing web scanning: " + addPath);
                    }
                } else {
                    addPath = "file:" + url + "META-INF/beans.xml";
                    if (this.logger.wblWillLogDebug()) {
                        this.logger.debug("OpenWebBeans added the following file based path while doing web scanning: " + addPath);
                    }
                }
                listURL.add(url);
            }
        }
        return listURL;
    }

    protected String createURLFromWARFile() throws Exception {
        if (this.servletContext == null) {
            return null;
        }
        URL url = this.servletContext.getResource("/WEB-INF/beans.xml");
        if (url != null) {
            this.addWebBeansXmlLocation(url);
            URL resourceUrl = WarUrlFinder.findWebInfClassesPath((ServletContext)this.servletContext);
            if (resourceUrl == null) {
                return null;
            }
            AnnotationDB annotationDB = this.getAnnotationDB();
            if (annotationDB instanceof BeansXmlAnnotationDB) {
                ((BeansXmlAnnotationDB)annotationDB).setResourceBeansXml(resourceUrl.toExternalForm(), url.toExternalForm());
            }
            return resourceUrl.toExternalForm();
        }
        return null;
    }
}

