/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Delegate;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.DecoratorBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;

public class DecoratorBeanBuilder<T> {
    private static Logger logger = WebBeansLoggerFacade.getLogger(DecoratorBeanBuilder.class);
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected final BeanAttributesImpl<T> beanAttributes;
    private Set<Type> decoratedTypes;
    private Type delegateType;
    private Set<Annotation> delegateQualifiers;
    private final Set<String> ignoredDecoratorInterfaces;

    public DecoratorBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributesImpl<T> beanAttributes) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        Asserts.assertNotNull(beanAttributes, "beanAttributes may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
        this.beanAttributes = beanAttributes;
        this.decoratedTypes = new HashSet<Type>(beanAttributes.getTypes());
        this.ignoredDecoratorInterfaces = this.getIgnoredDecoratorInterfaces();
    }

    private Set<String> getIgnoredDecoratorInterfaces() {
        return this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredInterfaces();
    }

    public boolean isDecoratorEnabled() {
        return this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(this.annotatedType.getJavaClass());
    }

    protected void checkDecoratorConditions() {
        if (this.beanAttributes.getScope() != Dependent.class && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARN_0005_1", this.annotatedType.getJavaClass().getName());
        }
        if (this.beanAttributes.getName() != null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARN_0005_2", this.annotatedType.getJavaClass().getName());
        }
        if (this.annotatedType.isAnnotationPresent(Alternative.class) && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARN_0005_3", this.annotatedType.getJavaClass().getName());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Configuring decorator class : [{0}]", this.annotatedType.getJavaClass());
        }
        Set methods = this.annotatedType.getMethods();
        for (AnnotatedMethod method : methods) {
            for (AnnotatedParameter parameter : method.getParameters()) {
                if (!parameter.isAnnotationPresent(Produces.class)) continue;
                throw new WebBeansConfigurationException("Interceptor class : " + this.annotatedType.getJavaClass() + " can not have producer methods but it has one with name : " + method.getJavaMember().getName());
            }
        }
    }

    public void defineDecoratorRules() {
        this.checkDecoratorConditions();
        this.defineDecoratedTypes();
    }

    private void defineDecoratedTypes() {
        this.decoratedTypes.remove(Serializable.class);
        Iterator<Type> i = this.decoratedTypes.iterator();
        while (i.hasNext()) {
            Type t = i.next();
            if (ClassUtil.getClass(t).isInterface() && (!(t instanceof Class) || !this.ignoredDecoratorInterfaces.contains(((Class)t).getName()))) continue;
            i.remove();
        }
    }

    private void defineDelegate(Set<InjectionPoint> injectionPoints) {
        AnnotatedElement element;
        boolean found = false;
        InjectionPoint ipFound = null;
        for (InjectionPoint ip : injectionPoints) {
            if (!ip.getAnnotated().isAnnotationPresent(Delegate.class)) continue;
            if (!found) {
                found = true;
                ipFound = ip;
                continue;
            }
            throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point. But the decorator bean : " + this.toString() + " has more than one");
        }
        if (ipFound == null) {
            throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point.But the decorator bean : " + this.toString() + " has none");
        }
        if (!(ipFound.getMember() instanceof Constructor) && !(element = (AnnotatedElement)((Object)ipFound.getMember())).isAnnotationPresent(Inject.class)) {
            String message = "Error in decorator : " + this.toString() + ". The delegate injection point must be an injected field, " + "initializer method parameter or bean constructor method parameter.";
            throw new WebBeansConfigurationException(message);
        }
        this.delegateType = GenericsUtil.resolveType(ipFound.getType(), this.annotatedType.getJavaClass(), ipFound.getMember());
        this.delegateQualifiers = ipFound.getQualifiers();
        for (Type decType : this.decoratedTypes) {
            if (!ClassUtil.getClass(decType).isAssignableFrom(ClassUtil.getClass(this.delegateType))) {
                throw new WebBeansConfigurationException("Decorator : " + this.toString() + " delegate attribute must implement all of the decorator decorated types" + ", but decorator type " + decType + " is not assignable from delegate type of " + this.delegateType);
            }
            if (ClassUtil.isParametrizedType(decType) && ClassUtil.isParametrizedType(this.delegateType)) {
                this.checkParametrizedType();
                continue;
            }
            if (!ClassUtil.isTypeVariable(decType) || this.delegateType.equals(this.delegateType)) continue;
            throw new WebBeansConfigurationException("Decorator : " + this.toString() + " generic delegate attribute must be same with decorated type : " + decType);
        }
    }

    private void checkParametrizedType() {
        Type[] interfaceTypes;
        Type[] delegeteTypes = ((ParameterizedType)this.delegateType).getActualTypeArguments();
        for (Type interfaceType : interfaceTypes = this.annotatedType.getJavaClass().getGenericInterfaces()) {
            if (!ClassUtil.isClassAssignable(ClassUtil.getClass(this.delegateType), ClassUtil.getClass(interfaceType))) continue;
            Type[] arguments = ClassUtil.getActualTypeArguments(interfaceType);
            if (arguments.length != delegeteTypes.length) {
                throw new DefinitionException("Decorator: " + this.toString() + " Number of TypeArguments must match - Decorated Type:  " + arguments.length + " Delegate Type: " + delegeteTypes.length);
            }
            for (int i = 0; i < delegeteTypes.length; ++i) {
                if (delegeteTypes[i].equals(arguments[i])) continue;
                throw new DefinitionException("Decorator: " + this.toString() + " delegate attribute must match decorated type: " + delegeteTypes[i]);
            }
        }
    }

    public DecoratorBean<T> getBean() {
        DecoratorBean<T> decorator = new DecoratorBean<T>(this.webBeansContext, WebBeansType.MANAGED, this.annotatedType, this.beanAttributes, this.annotatedType.getJavaClass());
        decorator.setEnabled(this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(this.annotatedType.getJavaClass()));
        this.defineDelegate(decorator.getInjectionPoints());
        decorator.setDecoratorInfo(this.decoratedTypes, this.delegateType, this.delegateQualifiers);
        return decorator;
    }

    protected List<AnnotatedMethod<?>> getPostConstructMethods() {
        ArrayList postConstructMethods = new ArrayList();
        this.collectPostConstructMethods(this.annotatedType.getJavaClass(), postConstructMethods);
        return postConstructMethods;
    }

    private void collectPostConstructMethods(Class<?> type, List<AnnotatedMethod<?>> postConstructMethods) {
        if (type == null) {
            return;
        }
        this.collectPostConstructMethods(type.getSuperclass(), postConstructMethods);
        for (AnnotatedMethod annotatedMethod : this.annotatedType.getMethods()) {
            if (annotatedMethod.getJavaMember().getDeclaringClass() != type || !annotatedMethod.isAnnotationPresent(PostConstruct.class) || !annotatedMethod.getParameters().isEmpty()) continue;
            postConstructMethods.add(annotatedMethod);
        }
    }

    protected List<AnnotatedMethod<?>> getPreDestroyMethods() {
        ArrayList preDestroyMethods = new ArrayList();
        this.collectPreDestroyMethods(this.annotatedType.getJavaClass(), preDestroyMethods);
        return preDestroyMethods;
    }

    private void collectPreDestroyMethods(Class<?> type, List<AnnotatedMethod<?>> preDestroyMethods) {
        if (type == null) {
            return;
        }
        this.collectPreDestroyMethods(type.getSuperclass(), preDestroyMethods);
        for (AnnotatedMethod annotatedMethod : this.annotatedType.getMethods()) {
            if (annotatedMethod.getJavaMember().getDeclaringClass() != type || !annotatedMethod.isAnnotationPresent(PreDestroy.class) || !annotatedMethod.getParameters().isEmpty()) continue;
            preDestroyMethods.add(annotatedMethod);
        }
    }
}

