/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerFieldProducer<T, P>
extends AbstractProducer<T> {
    private Bean<P> owner;
    private WebBeansContext webBeansContext;
    private AnnotatedField<? super P> producerField;

    public ProducerFieldProducer(Bean<P> owner, AnnotatedField<? super P> producerField, WebBeansContext context) {
        super(Collections.<InjectionPoint>emptySet());
        Asserts.assertNotNull(owner, "owner may not be null");
        Asserts.assertNotNull(producerField, "field may not be null");
        Asserts.assertNotNull(context, "WebBeansContext may not be null");
        this.owner = owner;
        this.webBeansContext = context;
        this.producerField = producerField;
    }

    @Override
    protected T produce(Map<Interceptor<?>, ?> interceptors, CreationalContextImpl<T> creationalContext) {
        Object instance = null;
        Object parentInstance = null;
        CreationalContext parentCreational = null;
        try {
            parentCreational = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)this.owner);
            Field field = this.producerField.getJavaMember();
            if (!field.isAccessible()) {
                this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)field, true);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                instance = field.get(null);
            } else {
                parentInstance = this.getParentInstanceFromContext(parentCreational);
                instance = field.get(parentInstance);
            }
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
        finally {
            if (this.owner.getScope().equals(Dependent.class)) {
                this.owner.destroy(parentInstance, parentCreational);
            }
        }
        return (T)instance;
    }

    protected P getParentInstanceFromContext(CreationalContext<?> creationalContext) {
        Bean<?> specialize = WebBeansUtil.getMostSpecializedBean(this.webBeansContext.getBeanManagerImpl(), (AbstractOwbBean)this.owner);
        Object parentInstance = specialize != null ? this.webBeansContext.getBeanManagerImpl().getContext(specialize.getScope()).get(specialize, creationalContext) : this.webBeansContext.getBeanManagerImpl().getContext(this.owner.getScope()).get(this.owner, creationalContext);
        return (P)parentInstance;
    }
}

