/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.decorator.DecoratorResolverRules;
import org.apache.webbeans.decorator.OwbDecorator;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableField;
import org.apache.webbeans.inject.InjectableMethods;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBeansDecorator<T>
extends AbstractInjectionTargetBean<T>
implements OwbDecorator<T> {
    private Class<?> clazz;
    private Set<Type> decoratedTypes = new HashSet<Type>();
    protected Type delegateType;
    protected Set<Annotation> delegateBindings = new HashSet<Annotation>();
    protected Field delegateField;
    private AbstractInjectionTargetBean<T> wrappedBean;
    private Decorator<T> customDecorator = null;
    private final Set<String> ignoredDecoratorInterfaces;

    public WebBeansDecorator(AbstractInjectionTargetBean<T> wrappedBean, Decorator<T> customDecorator) {
        super(WebBeansType.DECORATOR, wrappedBean.getReturnType(), wrappedBean.getWebBeansContext());
        this.wrappedBean = wrappedBean;
        this.customDecorator = customDecorator;
        this.ignoredDecoratorInterfaces = WebBeansDecorator.getIgnoredDecoratorInterfaces(wrappedBean);
        this.initDelegate();
    }

    public WebBeansDecorator(AbstractInjectionTargetBean<T> wrappedBean) {
        super(WebBeansType.DECORATOR, wrappedBean.getReturnType(), wrappedBean.getWebBeansContext());
        this.wrappedBean = wrappedBean;
        this.clazz = wrappedBean.getReturnType();
        this.ignoredDecoratorInterfaces = WebBeansDecorator.getIgnoredDecoratorInterfaces(wrappedBean);
        this.init();
    }

    private static <T> Set<String> getIgnoredDecoratorInterfaces(AbstractInjectionTargetBean<T> wrappedBean) {
        HashSet<String> result = new HashSet<String>(wrappedBean.getWebBeansContext().getOpenWebBeansConfiguration().getIgnoredInterfaces());
        result.add(Serializable.class.getName());
        return result;
    }

    protected void init() {
        ClassUtil.setInterfaceTypeHierarchy(this.decoratedTypes, this.clazz);
        Iterator<Type> i = this.decoratedTypes.iterator();
        while (i.hasNext()) {
            Type t = i.next();
            if (!(t instanceof Class) || !this.ignoredDecoratorInterfaces.contains(((Class)t).getName())) continue;
            i.remove();
        }
        this.initDelegate();
    }

    protected void initDelegate() {
        AnnotatedElement element;
        Set<InjectionPoint> injectionPoints = this.getInjectionPoints();
        boolean found = false;
        InjectionPoint ipFound = null;
        for (InjectionPoint ip : injectionPoints) {
            if (!ip.getAnnotated().isAnnotationPresent(Delegate.class)) continue;
            if (!found) {
                found = true;
                ipFound = ip;
                continue;
            }
            throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point. But the decorator bean : " + this.toString() + " has more than one");
        }
        if (ipFound == null) {
            throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point.But the decorator bean : " + this.toString() + " has none");
        }
        String message = new String("Error in decorator : " + this.toString() + ". The delegate injection point must be an injected field, " + "initializer method parameter or bean constructor method parameter. ");
        if (!(ipFound.getMember() instanceof Constructor) && !(element = (AnnotatedElement)((Object)ipFound.getMember())).isAnnotationPresent(Inject.class)) {
            throw new WebBeansConfigurationException(message);
        }
        this.initDelegateInternal(ipFound);
    }

    @Override
    public boolean isPassivationCapable() {
        return this.wrappedBean.isPassivationCapable();
    }

    private void initDelegateInternal(InjectionPoint ip) {
        if (this.customDecorator != null) {
            this.delegateType = this.customDecorator.getDelegateType();
            this.delegateBindings = this.customDecorator.getDelegateQualifiers();
        } else {
            this.delegateType = ip.getType();
            this.delegateBindings = ip.getQualifiers();
        }
        if (ip.getMember() instanceof Field) {
            this.delegateField = (Field)ip.getMember();
        } else {
            Field[] fields = ClassUtil.getFieldsWithType(this.wrappedBean.getWebBeansContext(), this.returnType, this.delegateType);
            if (fields.length == 0) {
                throw new WebBeansConfigurationException("Delegate injection field is not found for decorator : " + this.toString());
            }
            if (fields.length > 1) {
                throw new WebBeansConfigurationException("More than one delegate injection field is found for decorator : " + this.toString());
            }
            this.delegateField = fields[0];
        }
        Type fieldType = this.delegateField.getGenericType();
        for (Type decType : this.getDecoratedTypes()) {
            if (!ClassUtil.getClass(decType).isAssignableFrom(ClassUtil.getClass(fieldType))) {
                throw new WebBeansConfigurationException("Decorator : " + this.toString() + " delegate attribute must implement all of the decorator decorated types" + ", but decorator type " + decType + " is not assignable from delegate type of " + fieldType);
            }
            if (!ClassUtil.isParametrizedType(decType) || !ClassUtil.isParametrizedType(fieldType) || fieldType.equals(decType)) continue;
            throw new WebBeansConfigurationException("Decorator : " + this.toString() + " generic delegate attribute must be same with decorated type : " + decType);
        }
    }

    private boolean bindingMatchesAnnotations(Annotation bindingType, Set<Annotation> annotations) {
        for (Annotation annot : annotations) {
            if (!AnnotationUtil.isQualifierEqual(annot, bindingType)) continue;
            return true;
        }
        return false;
    }

    private boolean apiTypesMatchDelegateType(Set<Type> apiTypes) {
        boolean ok = false;
        for (Type apiType : apiTypes) {
            if (!DecoratorResolverRules.compareType(this.getDelegateType(), apiType)) continue;
            ok = true;
            break;
        }
        return ok;
    }

    @Override
    public boolean isDecoratorMatch(Set<Type> apiTypes, Set<Annotation> annotations) {
        if (!this.apiTypesMatchDelegateType(apiTypes)) {
            return false;
        }
        for (Annotation bindingType : this.getDelegateQualifiers()) {
            if (this.bindingMatchesAnnotations(bindingType, annotations)) continue;
            return false;
        }
        return true;
    }

    public Set<Annotation> getDelegateQualifiers() {
        if (this.customDecorator != null) {
            return this.customDecorator.getDelegateQualifiers();
        }
        return this.delegateBindings;
    }

    public Type getDelegateType() {
        if (this.customDecorator != null) {
            return this.customDecorator.getDelegateType();
        }
        return this.delegateType;
    }

    @Override
    public void setDelegate(Object instance, Object delegate) {
        if (!this.delegateField.isAccessible()) {
            this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.delegateField, true);
        }
        try {
            this.delegateField.set(instance, delegate);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("ERROR_0007", e, instance.getClass().getName());
            throw new WebBeansException(e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().error("ERROR_0015", e, this.delegateField.getName(), instance.getClass().getName());
        }
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        if (this.customDecorator != null) {
            return (T)this.customDecorator.create(creationalContext);
        }
        WebBeansContext webBeansContext = this.wrappedBean.getWebBeansContext();
        Context context = webBeansContext.getBeanManagerImpl().getContext(this.getScope());
        Object actualInstance = context.get(this.wrappedBean, creationalContext);
        Object proxy = webBeansContext.getJavassistProxyFactory().createDependentScopedBeanProxy(this.wrappedBean, actualInstance, creationalContext);
        return (T)proxy;
    }

    @Override
    public void setInjections(Object proxy, CreationalContext<?> cretionalContext) {
        block7: {
            block6: {
                if (this.customDecorator == null) break block6;
                Set injections = this.customDecorator.getInjectionPoints();
                if (injections == null) break block7;
                for (InjectionPoint ip : injections) {
                    if (ip.isDelegate()) continue;
                    Member member = ip.getMember();
                    if (member instanceof Field) {
                        this.injectField((Field)member, proxy, cretionalContext);
                    }
                    if (!(member instanceof Method)) continue;
                    this.injectMethod((Method)member, proxy, cretionalContext);
                }
                break block7;
            }
            ManagedBean delegate = (ManagedBean)this.wrappedBean;
            Set<Field> injectedFields = delegate.getInjectedFromSuperFields();
            for (Field injectedField : injectedFields) {
                boolean isDecorates = injectedField.isAnnotationPresent(Delegate.class);
                if (isDecorates) continue;
                this.injectField(injectedField, proxy, cretionalContext);
            }
            Set<Method> injectedMethods = delegate.getInjectedFromSuperMethods();
            for (Method injectedMethod : injectedMethods) {
                this.injectMethod(injectedMethod, proxy, cretionalContext);
            }
            injectedFields = delegate.getInjectedFields();
            for (Field injectedField : injectedFields) {
                boolean isDecorates = injectedField.isAnnotationPresent(Delegate.class);
                if (isDecorates) continue;
                this.injectField(injectedField, proxy, cretionalContext);
            }
            injectedMethods = delegate.getInjectedMethods();
            for (Method injectedMethod : injectedMethods) {
                this.injectMethod(injectedMethod, proxy, cretionalContext);
            }
        }
    }

    private void injectField(Field field, Object instance, CreationalContext<?> creationalContext) {
        InjectableField f = new InjectableField(field, instance, this.wrappedBean, creationalContext);
        f.doInjection();
    }

    private void injectMethod(Method method, Object instance, CreationalContext<?> creationalContext) {
        InjectableMethods m = new InjectableMethods(method, instance, this.wrappedBean, creationalContext);
        m.doInjection();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        if (this.customDecorator != null) {
            return this.customDecorator.getQualifiers();
        }
        return this.wrappedBean.getQualifiers();
    }

    @Override
    public String getName() {
        if (this.customDecorator != null) {
            return this.customDecorator.getName();
        }
        return this.wrappedBean.getName();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        if (this.customDecorator != null) {
            return this.customDecorator.getScope();
        }
        return this.wrappedBean.getScope();
    }

    @Override
    public Set<Type> getTypes() {
        if (this.customDecorator != null) {
            return this.customDecorator.getTypes();
        }
        return this.wrappedBean.getTypes();
    }

    @Override
    public boolean isNullable() {
        if (this.customDecorator != null) {
            return this.customDecorator.isNullable();
        }
        return this.wrappedBean.isNullable();
    }

    @Override
    public boolean isSerializable() {
        return this.wrappedBean.isSerializable();
    }

    @Override
    public AbstractOwbBean<T> getDelegateComponent() {
        return this.wrappedBean;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        if (this.customDecorator != null) {
            return this.customDecorator.getInjectionPoints();
        }
        return this.wrappedBean.getInjectionPoints();
    }

    public Class<?> getClazz() {
        if (this.customDecorator != null) {
            return this.customDecorator.getBeanClass();
        }
        return this.clazz;
    }

    @Override
    public Class<?> getBeanClass() {
        if (this.customDecorator != null) {
            return this.customDecorator.getBeanClass();
        }
        return this.wrappedBean.getBeanClass();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        if (this.customDecorator != null) {
            return this.customDecorator.getStereotypes();
        }
        return this.wrappedBean.getStereotypes();
    }

    public Set<Type> getDecoratedTypes() {
        if (this.customDecorator != null) {
            return this.customDecorator.getDecoratedTypes();
        }
        return this.decoratedTypes;
    }

    @Override
    public boolean isAlternative() {
        if (this.customDecorator != null) {
            return this.customDecorator.isAlternative();
        }
        return this.wrappedBean.isAlternative();
    }

    @Override
    public void validatePassivationDependencies() {
        this.wrappedBean.validatePassivationDependencies();
    }
}

