/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context.creational;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.DependentCreationalContext;
import org.apache.webbeans.context.creational.EjbInterceptorContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreationalContextImpl<T>
implements CreationalContext<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Object, List<DependentCreationalContext<?>>> dependentObjects = null;
    private Contextual<T> contextual = null;
    private ConcurrentMap<Object, List<EjbInterceptorContext>> ejbInterceptors = null;
    private WebBeansContext webBeansContext;
    private boolean destroying = false;

    CreationalContextImpl(Contextual<T> contextual, WebBeansContext webBeansContext) {
        this.contextual = contextual;
        this.webBeansContext = webBeansContext;
    }

    public void addEjbInterceptor(Object ownerInstance, EjbInterceptorContext instance) {
        List oldList;
        Asserts.assertNotNull(ownerInstance, "Owner instance parameter can not be null");
        Asserts.assertNotNull(instance, "Instance parameter can not be null");
        List<EjbInterceptorContext> list = null;
        if (this.ejbInterceptors == null) {
            this.ejbInterceptors = new ConcurrentHashMap<Object, List<EjbInterceptorContext>>();
        } else {
            list = (ArrayList<EjbInterceptorContext>)this.ejbInterceptors.get(ownerInstance);
        }
        if (list == null && (oldList = (List)this.ejbInterceptors.putIfAbsent(ownerInstance, list = new ArrayList<EjbInterceptorContext>())) != null) {
            list = oldList;
        }
        list.add(instance);
    }

    public EjbInterceptorContext getEjbInterceptor(Object ownerInstance, Class<?> clazz) {
        Asserts.assertNotNull(ownerInstance, "Owner instance can not be null");
        if (this.ejbInterceptors == null) {
            return null;
        }
        List ejbInts = (List)this.ejbInterceptors.get(ownerInstance);
        if (ejbInts != null) {
            for (EjbInterceptorContext ejbInterceptor : ejbInts) {
                if (ejbInterceptor.getInterceptorClass() != clazz) continue;
                return ejbInterceptor;
            }
        }
        return null;
    }

    public void push(T incompleteInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> void addDependent(Object ownerInstance, Contextual<K> dependent, Object instance) {
        Asserts.assertNotNull(dependent, "dependent parameter cannot be null");
        if (instance != null) {
            DependentCreationalContext<K> dependentCreational = new DependentCreationalContext<K>(dependent);
            if (dependent instanceof Interceptor) {
                dependentCreational.setDependentType(DependentCreationalContext.DependentType.INTERCEPTOR);
            } else if (dependent instanceof Decorator) {
                dependentCreational.setDependentType(DependentCreationalContext.DependentType.DECORATOR);
            } else {
                dependentCreational.setDependentType(DependentCreationalContext.DependentType.BEAN);
            }
            dependentCreational.setInstance(instance);
            CreationalContextImpl creationalContextImpl = this;
            synchronized (creationalContextImpl) {
                List<DependentCreationalContext<?>> dependentList;
                if (this.dependentObjects == null) {
                    this.dependentObjects = new HashMap();
                }
                if ((dependentList = this.dependentObjects.get(ownerInstance)) == null) {
                    dependentList = new ArrayList();
                    this.dependentObjects.put(ownerInstance, dependentList);
                }
                dependentList.add(dependentCreational);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDependentInterceptor(Object ownerInstance, Contextual<?> interceptor) {
        Asserts.assertNotNull(interceptor, "Interceptor parameter can not be null");
        if (ownerInstance == null || this.dependentObjects == null) {
            return null;
        }
        CreationalContextImpl creationalContextImpl = this;
        synchronized (creationalContextImpl) {
            List<DependentCreationalContext<?>> values = this.dependentObjects.get(ownerInstance);
            if (values != null && !values.isEmpty()) {
                for (DependentCreationalContext<?> dc : values) {
                    if (!dc.getDependentType().equals((Object)DependentCreationalContext.DependentType.INTERCEPTOR) || !dc.getContextual().equals(interceptor)) continue;
                    return dc.getInstance();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDependentDecorator(Object ownerInstance, Contextual<?> decorator) {
        Asserts.assertNotNull(decorator, "Decorator parameter can not be null");
        if (ownerInstance == null || this.dependentObjects == null) {
            return null;
        }
        CreationalContextImpl creationalContextImpl = this;
        synchronized (creationalContextImpl) {
            List<DependentCreationalContext<?>> values = this.dependentObjects.get(ownerInstance);
            if (values != null && values.size() > 0) {
                for (DependentCreationalContext<?> dc : values) {
                    if (!dc.getDependentType().equals((Object)DependentCreationalContext.DependentType.DECORATOR) || !dc.getContextual().equals(decorator)) continue;
                    return dc.getInstance();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDependents() {
        if (this.dependentObjects == null || this.destroying) {
            return;
        }
        this.destroying = true;
        CreationalContextImpl creationalContextImpl = this;
        synchronized (creationalContextImpl) {
            Collection<List<DependentCreationalContext<?>>> values = this.dependentObjects.values();
            if (values != null) {
                for (List<DependentCreationalContext<?>> value : values) {
                    int maxRemoval;
                    for (maxRemoval = value.size() * 3; !value.isEmpty() && maxRemoval > 0; --maxRemoval) {
                        DependentCreationalContext<?> dependent = value.get(0);
                        dependent.getContextual().destroy(dependent.getInstance(), (CreationalContext)this);
                        value.remove(0);
                    }
                    if (maxRemoval != 0) continue;
                    throw new WebBeansException("infinite loop detected while destroying bean " + this.contextual);
                }
            }
            this.dependentObjects = null;
        }
        Collection interceptorValues = null;
        if (this.ejbInterceptors != null) {
            interceptorValues = this.ejbInterceptors.values();
        }
        if (interceptorValues != null) {
            for (List interceptors : interceptorValues) {
                if (interceptors == null) continue;
                for (EjbInterceptorContext intereptor : interceptors) {
                    intereptor.getInjectorInstance().destroy();
                }
            }
            this.ejbInterceptors.clear();
        }
    }

    public void release() {
        this.removeAllDependents();
    }

    public Contextual<T> getBean() {
        return this.contextual;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.dependentObjects);
        String id = WebBeansUtil.isPassivationCapable(this.contextual);
        if (this.contextual != null && id != null) {
            s.writeObject(id);
        } else {
            s.writeObject(null);
        }
        s.writeObject(this.ejbInterceptors);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.webBeansContext = WebBeansContext.currentInstance();
        this.dependentObjects = (HashMap)s.readObject();
        String id = (String)s.readObject();
        if (id != null) {
            this.contextual = this.webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id);
        }
        this.ejbInterceptors = (ConcurrentMap)s.readObject();
    }

    public String toString() {
        String name;
        if (this.contextual instanceof Bean) {
            Bean bean = (Bean)this.contextual;
            name = bean.getBeanClass().getSimpleName();
        } else {
            name = "unknown";
        }
        return String.format("CreationalContext{name=%s}", name);
    }
}

