/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.ppr;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidadinternal.io.ResponseWriterDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBufferingResponseWriter
extends ResponseWriterDecorator {
    private boolean _inScript;
    private StringBuilder _scriptBuilder;
    private List<String> _libraries = new ArrayList<String>();
    private List<String> _scripts = new ArrayList<String>();

    public ScriptBufferingResponseWriter(ResponseWriter out) {
        super(out);
    }

    ScriptBufferingResponseWriter(ResponseWriter out, ScriptBufferingResponseWriter base) {
        super(out);
        this._scripts = base._scripts;
        this._libraries = base._libraries;
    }

    public List<String> getBufferedScripts() {
        if (this._scripts != null) {
            return Collections.unmodifiableList(this._scripts);
        }
        return null;
    }

    public List<String> getBufferedLibraries() {
        if (this._libraries != null) {
            return Collections.unmodifiableList(this._libraries);
        }
        return null;
    }

    public void clearBufferedContents() {
        this._scripts = null;
        this._libraries = null;
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer writer) {
        ScriptBufferingResponseWriter rw = new ScriptBufferingResponseWriter(this.getResponseWriter().cloneWithWriter(writer));
        return rw;
    }

    @Override
    public void writeComment(Object text) throws IOException {
        if (this._inScript) {
            if (text != null) {
                this._getScriptBuilder().append(text);
            }
        } else {
            super.writeComment(text);
        }
    }

    @Override
    public void writeText(Object text, String property) throws IOException {
        if (this._inScript) {
            if (text != null) {
                this._getScriptBuilder().append(text);
            }
        } else {
            super.writeText(text, property);
        }
    }

    @Override
    public void writeText(char[] text, int start, int length) throws IOException {
        if (this._inScript) {
            this._getScriptBuilder().append(text, start, length);
        } else {
            super.writeText(text, start, length);
        }
    }

    @Override
    public void write(String text) throws IOException {
        if (this._inScript) {
            this._getScriptBuilder().append(text);
        } else {
            super.write(text);
        }
    }

    @Override
    public void write(char[] text, int start, int length) throws IOException {
        if (this._inScript) {
            this._getScriptBuilder().append(text, start, length);
        } else {
            super.write(text, start, length);
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this._inScript) {
            this._getScriptBuilder().append(ch);
        } else {
            super.write(ch);
        }
    }

    @Override
    public void write(char[] c) throws IOException {
        if (this._inScript) {
            this._getScriptBuilder().append(c);
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(String text, int off, int len) throws IOException {
        if (this._inScript) {
            this._getScriptBuilder().append(text, off, len);
        } else {
            super.write(text, off, len);
        }
    }

    @Override
    public void startElement(String name, UIComponent component) throws IOException {
        if ("script".equals(name)) {
            this._inScript = true;
        } else {
            super.startElement(name, component);
        }
    }

    @Override
    public void endElement(String name) throws IOException {
        if (this._inScript) {
            if (this._scriptBuilder != null) {
                this._getScriptList().add(this._scriptBuilder.toString());
            }
            this._scriptBuilder = null;
            this._inScript = false;
        } else {
            super.endElement(name);
        }
    }

    @Override
    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (value == null) {
            return;
        }
        if (this._inScript) {
            if ("src".equals(name) && value != null) {
                this._getLibraryList().add(value.toString());
            }
        } else {
            super.writeAttribute(name, value, property);
        }
    }

    @Override
    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this._inScript) {
            if ("src".equals(name) && value != null) {
                this._getLibraryList().add(value.toString());
            }
        } else {
            super.writeURIAttribute(name, value, property);
        }
    }

    private StringBuilder _getScriptBuilder() {
        if (this._scriptBuilder == null) {
            this._scriptBuilder = new StringBuilder();
        }
        return this._scriptBuilder;
    }

    private List<String> _getLibraryList() {
        return this._libraries;
    }

    private List<String> _getScriptList() {
        return this._scripts;
    }
}

