/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.maven.plugin;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.myfaces.maven.plugin.AbstractAPTMojo;
import org.apache.myfaces.maven.plugin.AllSourcesInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public class AptMojo
extends AbstractAPTMojo {
    private String generated;
    private List compileSourceRoots;
    private List aptSourceRoots;
    private List classpathElements;
    private File outputDirectory;
    private Set includes = new HashSet();
    private Set excludes = new HashSet();

    protected String getGenerated() {
        return this.generated;
    }

    protected List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    protected List getClasspathElements() {
        return this.classpathElements;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected List getAptSourceRoots() {
        return this.aptSourceRoots;
    }

    public void execute() throws MojoExecutionException {
        super.execute();
        File absoluteGeneratedPath = new File(this.getProject().getBasedir(), this.getGenerated());
        this.getProject().addCompileSourceRoot(absoluteGeneratedPath.getPath());
        Resource resource = new Resource();
        resource.setFiltering(this.isResourceFiltering());
        if (this.getResourceTargetPath() != null) {
            resource.setTargetPath(this.getResourceTargetPath());
        }
        resource.setDirectory(absoluteGeneratedPath.getPath());
        resource.addExclude("**/*.java");
        this.getProject().addResource(resource);
    }

    protected SourceInclusionScanner getSourceInclusionScanner() {
        StaleSourceScanner scanner = null;
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.java");
        }
        if (this.isForce()) {
            return new AllSourcesInclusionScanner(this.includes, this.excludes);
        }
        scanner = new StaleSourceScanner((long)this.getStaleMillis(), this.includes, this.excludes);
        if (this.getTargetFiles() != null && this.getTargetFiles().size() > 0) {
            for (String file : this.getTargetFiles()) {
                scanner.addSourceMapping((SourceMapping)new SingleTargetSourceMapping(".java", file));
            }
        } else {
            scanner.addSourceMapping((SourceMapping)new SuffixMapping(".java", ".class"));
        }
        return scanner;
    }
}

