/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;

public class MockPortletContext
implements PortletContext {
    private Hashtable attributes = new Hashtable();
    private File documentRoot = null;
    private Hashtable mimeTypes = new Hashtable();
    private Hashtable parameters = new Hashtable();

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addMimeType(String extension, String contentType) {
        this.mimeTypes.put(extension, contentType);
    }

    public void setDocumentRoot(File documentRoot) {
        this.documentRoot = documentRoot;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.parameters.keys();
    }

    public int getMajorVersion() {
        return 1;
    }

    public String getMimeType(String path) {
        int period = path.lastIndexOf(46);
        if (period < 0) {
            return null;
        }
        String extension = path.substring(period + 1);
        return (String)this.mimeTypes.get(extension);
    }

    public int getMinorVersion() {
        return 0;
    }

    public PortletRequestDispatcher getNamedDispatcher(String arg0) {
        throw new UnsupportedOperationException();
    }

    public String getPortletContextName() {
        return "MockPortletContext";
    }

    public String getRealPath(String path) {
        if (this.documentRoot != null) {
            if (!path.startsWith("/")) {
                throw new IllegalArgumentException("The specified path ('" + path + "') does not start with a '/' character");
            }
            File resolved = new File(this.documentRoot, path.substring(1));
            try {
                return resolved.getCanonicalPath();
            }
            catch (IOException e) {
                return resolved.getAbsolutePath();
            }
        }
        return null;
    }

    public PortletRequestDispatcher getRequestDispatcher(String arg0) {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.documentRoot != null) {
            if (!path.startsWith("/")) {
                throw new MalformedURLException("The specified path ('" + path + "') does not start with a '/' character");
            }
            File resolved = new File(this.documentRoot, path.substring(1));
            if (resolved.exists()) {
                return resolved.toURL();
            }
            return null;
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL url = this.getResource(path);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        if (this.documentRoot == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The specified path ('" + path + "') does not start with a '/' character");
        }
        File node = new File(this.documentRoot, path.substring(1));
        if (!node.exists()) {
            return null;
        }
        if (!node.isDirectory()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        String[] files = node.list();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            String subfile = path + files[i];
            File subnode = new File(node, files[i]);
            if (subnode.isDirectory()) {
                subfile = subfile + "/";
            }
            set.add(subfile);
        }
        return set;
    }

    public String getServerInfo() {
        return "MockPortletContext";
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(String message, Throwable exception) {
        System.out.println(message);
        exception.printStackTrace();
    }

    public void removeAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        this.attributes.put(name, value);
    }
}

