/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.client.protocol;

import java.io.IOException;
import org.apache.maven.wagon.providers.http.commons.logging.Log;
import org.apache.maven.wagon.providers.http.commons.logging.LogFactory;
import org.apache.maven.wagon.providers.http.httpclient.Header;
import org.apache.maven.wagon.providers.http.httpclient.HttpException;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequest;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequestInterceptor;
import org.apache.maven.wagon.providers.http.httpclient.annotation.Immutable;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthScheme;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthState;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthenticationException;
import org.apache.maven.wagon.providers.http.httpclient.auth.ContextAwareAuthScheme;
import org.apache.maven.wagon.providers.http.httpclient.auth.Credentials;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpContext;

@Immutable
public class RequestTargetAuthentication
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        block10: {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            String method = request.getRequestLine().getMethod();
            if (method.equalsIgnoreCase("CONNECT")) {
                return;
            }
            if (request.containsHeader("Authorization")) {
                return;
            }
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState == null) {
                this.log.debug("Target auth state not set in the context");
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials creds = authState.getCredentials();
            if (creds == null) {
                this.log.debug("User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    Header header = authScheme instanceof ContextAwareAuthScheme ? ((ContextAwareAuthScheme)authScheme).authenticate(creds, request, context) : authScheme.authenticate(creds, request);
                    request.addHeader(header);
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error("Authentication error: " + ex.getMessage());
                }
            }
        }
    }
}

