/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit48.FilterFactory;
import org.apache.maven.surefire.common.junit48.JUnit48Reflector;
import org.apache.maven.surefire.common.junit48.JUnit48TestChecker;
import org.apache.maven.surefire.junitcore.ConcurrentRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.JUnitCoreRunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreWrapper;
import org.apache.maven.surefire.junitcore.NonConcurrentRunListener;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;

public class JUnitCoreProvider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final JUnitCoreParameters jUnitCoreParameters;
    private final ScannerFilter scannerFilter;
    private final List<RunListener> customRunListeners;
    private final ProviderParameters providerParameters;
    private TestsToRun testsToRun;
    private JUnit48Reflector jUnit48Reflector;
    private RunOrderCalculator runOrderCalculator;
    private String requestedTestMethod;
    private final ScanResult scanResult;

    public JUnitCoreProvider(ProviderParameters providerParameters) {
        this.providerParameters = providerParameters;
        this.testClassLoader = providerParameters.getTestClassLoader();
        this.scanResult = providerParameters.getScanResult();
        this.runOrderCalculator = providerParameters.getRunOrderCalculator();
        this.jUnitCoreParameters = new JUnitCoreParameters(providerParameters.getProviderProperties());
        this.scannerFilter = new JUnit48TestChecker(this.testClassLoader);
        this.requestedTestMethod = providerParameters.getTestRequest().getRequestedTestMethod();
        this.customRunListeners = JUnit4RunListenerFactory.createCustomListeners(providerParameters.getProviderProperties().getProperty("listener"));
        this.jUnit48Reflector = new JUnit48Reflector(this.testClassLoader);
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }

    public Iterator getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    private boolean isSingleThreaded() {
        return this.jUnitCoreParameters.isNoThreading();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        Filter filter;
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        ConsoleLogger consoleLogger = this.providerParameters.getConsoleLogger();
        Filter filter2 = filter = this.jUnit48Reflector.isJUnit48Available() ? this.createJUnit48Filter() : null;
        if (this.testsToRun == null) {
            if (forkTestSet instanceof TestsToRun) {
                this.testsToRun = (TestsToRun)forkTestSet;
            } else if (forkTestSet instanceof Class) {
                Class theClass = (Class)forkTestSet;
                this.testsToRun = TestsToRun.fromClass((Class)theClass);
            } else {
                this.testsToRun = this.scanClassPath();
            }
        }
        RunListener jUnit4RunListener = this.getRunListener(reporterFactory, consoleLogger);
        this.customRunListeners.add(0, jUnit4RunListener);
        JUnitCoreWrapper.execute(this.testsToRun, this.jUnitCoreParameters, this.customRunListeners, filter);
        return reporterFactory.close();
    }

    private RunListener getRunListener(ReporterFactory reporterFactory, ConsoleLogger consoleLogger) throws TestSetFailedException {
        JUnit4RunListener jUnit4RunListener;
        if (this.isSingleThreaded()) {
            NonConcurrentRunListener rm = new NonConcurrentRunListener(reporterFactory.createReporter());
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)rm);
            jUnit4RunListener = rm;
        } else {
            ConcurrentHashMap<String, TestSet> testSetMap = new ConcurrentHashMap<String, TestSet>();
            ConcurrentRunListener listener = ConcurrentRunListener.createInstance(testSetMap, reporterFactory, this.isParallelTypes(), this.isParallelMethodsAndTypes(), consoleLogger);
            ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)listener);
            jUnit4RunListener = new JUnitCoreRunListener(listener, testSetMap);
        }
        return jUnit4RunListener;
    }

    private boolean isParallelMethodsAndTypes() {
        return this.jUnitCoreParameters.isParallelMethods() && this.isParallelTypes();
    }

    private boolean isParallelTypes() {
        return this.jUnitCoreParameters.isParallelClasses() || this.jUnitCoreParameters.isParallelSuites();
    }

    private Filter createJUnit48Filter() {
        FilterFactory filterFactory = new FilterFactory(this.testClassLoader);
        Filter groupFilter = filterFactory.createGroupFilter(this.providerParameters.getProviderProperties());
        return this.isMethodFilterSpecified() ? filterFactory.and(groupFilter, filterFactory.createMethodFilter(this.requestedTestMethod)) : groupFilter;
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter(this.scannerFilter, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }

    private boolean isMethodFilterSpecified() {
        return !StringUtils.isBlank((String)this.requestedTestMethod);
    }
}

