/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit;

import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.ScannerFilter;

public class JUnit3TestChecker
implements ScannerFilter {
    private final Class junitClass;
    private final NonAbstractClassFilter nonAbstractClassFilter = new NonAbstractClassFilter();

    public JUnit3TestChecker(ClassLoader testClassLoader) {
        this.junitClass = ReflectionUtils.tryLoadClass((ClassLoader)testClassLoader, (String)"junit.framework.Test");
    }

    public boolean accept(Class testClass) {
        return this.nonAbstractClassFilter.accept(testClass) && this.isValidJUnit3Test(testClass);
    }

    public boolean isValidJUnit3Test(Class testClass) {
        return this.isJunit3Test(testClass) || this.isPojoTest(testClass);
    }

    public boolean isJunit3Test(Class testClass) {
        return this.junitClass != null && this.junitClass.isAssignableFrom(testClass);
    }

    private boolean isPojoTest(Class testClass) {
        try {
            testClass.getConstructor(new Class[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

