/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.surefire.suite.RunResult;

public final class SurefireHelper {
    private SurefireHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void reportExecution(SurefireReportParameters reportParameters, RunResult result, Log log) throws MojoFailureException, MojoExecutionException {
        String msg;
        boolean timeoutOrOtherFailure = result.isFailureOrTimeout();
        if (!timeoutOrOtherFailure) {
            if (result.getCompletedCount() == 0) {
                if (reportParameters.getFailIfNoTests() == null || !reportParameters.getFailIfNoTests().booleanValue()) {
                    return;
                }
                throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
            }
            if (result.isErrorFree()) {
                return;
            }
        }
        String string = msg = timeoutOrOtherFailure ? "There was a timeout or other error in the fork" : "There are test failures.\n\nPlease refer to " + reportParameters.getReportsDirectory() + " for the individual test results.";
        if (!reportParameters.isTestFailureIgnore()) {
            if (result.isFailure()) {
                throw new MojoExecutionException(msg);
            }
            throw new MojoFailureException(msg);
        }
        log.error((CharSequence)msg);
    }
}

