/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.vss.commands.checkout;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.vss.commands.VssCommandLineUtils;
import org.apache.maven.scm.provider.vss.commands.checkout.VssCheckOutConsumer;
import org.apache.maven.scm.provider.vss.repository.VssScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class VssCheckOutCommand
extends AbstractCheckOutCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        this.getLogger().debug("executing checkout command...");
        VssScmProviderRepository repo = (VssScmProviderRepository)repository;
        Commandline cl = this.buildCmdLine(repo, fileSet, version);
        VssCheckOutConsumer consumer = new VssCheckOutConsumer(repo, this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
        int exitCode = VssCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            String error = stderr.getOutput();
            this.getLogger().debug("VSS returns error: [" + error + "] return code: [" + exitCode + "]");
            if (error.indexOf("A writable copy of") < 0) {
                return new CheckOutScmResult(cl.toString(), "The vss command failed.", error, false);
            }
            this.getLogger().warn(error);
        }
        return new CheckOutScmResult(cl.toString(), consumer.getUpdatedFiles());
    }

    public Commandline buildCmdLine(VssScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        try {
            command.addSystemEnvironment();
        }
        catch (Exception e) {
            throw new ScmException("Can't add system environment.", (Throwable)e);
        }
        command.addEnvironment("SSDIR", repo.getVssdir());
        String ssDir = VssCommandLineUtils.getSsDir();
        command.setExecutable(ssDir + "ss");
        command.createArgument().setValue("Get");
        command.createArgument().setValue("$" + repo.getProject());
        if (repo.getUserPassword() != null) {
            command.createArgument().setValue("-Y" + repo.getUserPassword());
        }
        command.createArgument().setValue("-R");
        command.createArgument().setValue("-I-");
        command.createArgument().setValue("-GWR");
        return command;
    }
}

