/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.vss.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.vss.repository.VssScmProviderRepository;
import org.apache.maven.scm.providers.vss.settings.Settings;
import org.apache.maven.scm.providers.vss.settings.io.xpp3.VssXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class VssCommandLineUtils {
    private static File scmConfDir = new File(System.getProperty("user.home"), ".scm");

    public static void addFiles(Commandline cl, ScmFileSet fileSet) {
        Iterator it = fileSet.getFileList().iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            cl.createArgument().setValue(file.getPath().replace('\\', '/'));
        }
    }

    public static Commandline getBaseVssCommandLine(File workingDirectory, String cmd, VssScmProviderRepository repository) {
        Commandline cl = new Commandline();
        cl.setExecutable("ss");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        if (!StringUtils.isEmpty((String)repository.getUser())) {
            cl.createArgument().setValue("-Y");
            StringBuffer sb = new StringBuffer(repository.getUser());
            if (!StringUtils.isEmpty((String)repository.getPassword())) {
                sb.append(",").append(repository.getPassword());
            }
            cl.createArgument().setValue(sb.toString());
        }
        return cl;
    }

    public static int executeCommandline(Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws ScmException {
        try {
            logger.info("Executing: " + cl);
            logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            int exitcode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
            logger.debug("VSS Command Exit_Code: " + exitcode);
            return exitcode;
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
    }

    public static final Settings getSettings() {
        String vssDirectory;
        Settings settings = null;
        File settingsFile = new File(scmConfDir, "vss-settings.xml");
        if (settingsFile.exists()) {
            VssXpp3Reader reader = new VssXpp3Reader();
            try {
                settings = reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        if (StringUtils.isNotEmpty((String)(vssDirectory = System.getProperty("vssDirectory")))) {
            if (settings == null) {
                settings = new Settings();
            }
            settings.setVssDirectory(vssDirectory);
        }
        return settings;
    }

    protected static final File getScmConfDir() {
        return scmConfDir;
    }

    protected static final void setScmConfDir(File directory) {
        scmConfDir = directory;
    }

    public static final String getSsDir() {
        String ssDir2;
        String ssDir = "";
        if (VssCommandLineUtils.getSettings() != null && (ssDir2 = VssCommandLineUtils.getSettings().getVssDirectory()) != null && !(ssDir = StringUtils.replace((String)ssDir2, (String)"\\", (String)"/")).endsWith("/")) {
            ssDir = ssDir + "/";
        }
        return ssDir;
    }
}

