/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.tfs.command.blame;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TfsBlameConsumer
extends AbstractConsumer {
    private static final String TFS_TIMESTAMP_PATTERN = "MM/dd/yyyy";
    private static final String LINE_PATTERN = "([^ ]+)[ ]+([^ ]+)[ ]+([^ ]+)";
    private RE lineRegexp;
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    public TfsBlameConsumer(ScmLogger logger) {
        super(logger);
        this.lineRegexp = new RE(LINE_PATTERN);
    }

    public void consumeLine(String line) {
        if (this.lineRegexp.match(line)) {
            String revision = this.lineRegexp.getParen(1).trim();
            String author = this.lineRegexp.getParen(2).trim();
            String dateStr = this.lineRegexp.getParen(3).trim();
            Date date = this.parseDate(dateStr, null, TFS_TIMESTAMP_PATTERN);
            this.lines.add(new BlameLine(date, revision, author));
        }
    }

    public List<BlameLine> getLines() {
        return this.lines;
    }
}

