/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.consumer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.synergy.util.SynergyTask;
import org.apache.maven.scm.util.AbstractConsumer;

public class SynergyGetCompletedTasksConsumer
extends AbstractConsumer {
    private String ccmDateFormat = "EEE MMM dd HH:mm:ss yyyy";
    private String language = "en";
    private String country = "US";
    public static final String OUTPUT_FORMAT = "%displayname#####%owner#####%completion_date#####%task_synopsis#####";
    private List entries = new ArrayList();

    public List getTasks() {
        return this.entries;
    }

    public SynergyGetCompletedTasksConsumer(ScmLogger logger) {
        super(logger);
        String country;
        String language;
        String dateFormat = System.getProperty("maven.scm.synergy.ccmDateFormat");
        if (dateFormat != null && !dateFormat.equals("")) {
            this.ccmDateFormat = dateFormat;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("dateFormat = " + this.ccmDateFormat);
        }
        if ((language = System.getProperty("maven.scm.synergy.language")) != null && !language.equals("")) {
            this.language = language;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("language = " + this.language);
        }
        if ((country = System.getProperty("maven.scm.synergy.country")) != null && !country.equals("")) {
            this.country = country;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("country = " + this.country);
        }
    }

    public void consumeLine(String line) {
        StringTokenizer tokenizer;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Consume: " + line);
        }
        if ((tokenizer = new StringTokenizer(line.trim(), "#####")).countTokens() == 4) {
            SynergyTask task;
            block8: {
                task = new SynergyTask();
                task.setNumber(Integer.parseInt(tokenizer.nextToken()));
                task.setUsername(tokenizer.nextToken());
                try {
                    task.setModifiedTime(new SimpleDateFormat(this.ccmDateFormat, new Locale(this.language, this.country)).parse(tokenizer.nextToken()));
                }
                catch (ParseException e) {
                    if (!this.getLogger().isErrorEnabled()) break block8;
                    this.getLogger().error("Wrong date format", (Throwable)e);
                }
            }
            task.setComment(tokenizer.nextToken());
            this.entries.add(task);
        } else {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Invalid token count in SynergyGetCompletedTasksConsumer [" + tokenizer.countTokens() + "]");
            }
            if (this.getLogger().isDebugEnabled()) {
                while (tokenizer.hasMoreElements()) {
                    this.getLogger().debug(tokenizer.nextToken());
                }
            }
        }
    }
}

