/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.command.update;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.synergy.command.SynergyCommand;
import org.apache.maven.scm.provider.synergy.command.changelog.SynergyChangeLogCommand;
import org.apache.maven.scm.provider.synergy.repository.SynergyScmProviderRepository;
import org.apache.maven.scm.provider.synergy.util.SynergyUtil;
import org.codehaus.plexus.util.FileUtils;

public class SynergyUpdateCommand
extends AbstractUpdateCommand
implements SynergyCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        File WAPath;
        this.getLogger().debug("executing update command...");
        SynergyScmProviderRepository repo = (SynergyScmProviderRepository)repository;
        this.getLogger().debug("basedir: " + fileSet.getBasedir());
        String CCM_ADDR = SynergyUtil.start(this.getLogger(), repo.getUser(), repo.getPassword(), null);
        try {
            String project_spec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), CCM_ADDR);
            SynergyUtil.reconfigureProperties(this.getLogger(), project_spec, CCM_ADDR);
            SynergyUtil.reconfigure(this.getLogger(), project_spec, CCM_ADDR);
            WAPath = SynergyUtil.getWorkArea(this.getLogger(), project_spec, CCM_ADDR);
        }
        finally {
            SynergyUtil.stop(this.getLogger(), CCM_ADDR);
        }
        File source = new File(WAPath, repo.getProjectName());
        ArrayList modifications = new ArrayList();
        if (!source.equals(fileSet.getBasedir())) {
            this.getLogger().info("We will copy modified files from Synergy Work Area [" + source + "] to expected folder [" + fileSet.getBasedir() + "]");
            try {
                SynergyUpdateCommand.copyDirectoryStructure(source, fileSet.getBasedir(), modifications);
            }
            catch (IOException e1) {
                throw new ScmException("Unable to copy directory structure", (Throwable)e1);
            }
        }
        return new UpdateScmResult("ccm reconcile -uwa ...", modifications);
    }

    protected ChangeLogCommand getChangeLogCommand() {
        SynergyChangeLogCommand changeLogCmd = new SynergyChangeLogCommand();
        changeLogCmd.setLogger(this.getLogger());
        return changeLogCmd;
    }

    public static void copyDirectoryStructure(File sourceDirectory, File destinationDirectory, List modifications) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                if (file.lastModified() == destination.lastModified()) continue;
                destination = destination.getParentFile();
                FileUtils.copyFileToDirectory((File)file, (File)destination);
                modifications.add(new ScmFile(file.getAbsolutePath(), ScmFileStatus.UPDATED));
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                SynergyUpdateCommand.copyDirectoryStructure(file, destination, modifications);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
    }
}

