/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.command.checkout;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.synergy.command.SynergyCommand;
import org.apache.maven.scm.provider.synergy.repository.SynergyScmProviderRepository;
import org.apache.maven.scm.provider.synergy.util.SynergyUtil;
import org.codehaus.plexus.util.FileUtils;

public class SynergyCheckOutCommand
extends AbstractCheckOutCommand
implements SynergyCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        List files;
        File WAPath;
        if (fileSet.getFileList().size() != 0) {
            throw new ScmException("This provider doesn't support checking out subsets of a project");
        }
        this.getLogger().debug("executing checkout command...");
        SynergyScmProviderRepository repo = (SynergyScmProviderRepository)repository;
        this.getLogger().debug("basedir: " + fileSet.getBasedir());
        String CCM_ADDR = SynergyUtil.start(this.getLogger(), repo.getUser(), repo.getPassword(), null);
        try {
            String project_spec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), CCM_ADDR);
            if (project_spec != null) {
                this.getLogger().info("A working project already exists [" + project_spec + "].");
                SynergyUtil.synchronize(this.getLogger(), project_spec, CCM_ADDR);
            } else {
                SynergyUtil.checkoutProject(this.getLogger(), null, repo.getProjectSpec(), version, repo.getProjectPurpose(), repo.getProjectRelease(), CCM_ADDR);
                project_spec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), CCM_ADDR);
                this.getLogger().info("A new working project [" + project_spec + "] was created.");
            }
            SynergyUtil.reconfigure(this.getLogger(), project_spec, CCM_ADDR);
            WAPath = SynergyUtil.getWorkArea(this.getLogger(), project_spec, CCM_ADDR);
        }
        finally {
            SynergyUtil.stop(this.getLogger(), CCM_ADDR);
        }
        File source = new File(WAPath, repo.getProjectName());
        this.getLogger().info("We will now copy files from Synergy Work Area [" + source + "] to expected folder [" + fileSet.getBasedir() + "]");
        try {
            FileUtils.copyDirectoryStructure((File)source, (File)fileSet.getBasedir());
        }
        catch (IOException e1) {
            throw new ScmException("Unable to copy directory structure", (Throwable)e1);
        }
        this.getLogger().debug("We will list content of checkout directory.");
        try {
            files = FileUtils.getFiles((File)fileSet.getBasedir(), null, (String)"_ccmwaid.inf");
        }
        catch (IOException e) {
            throw new ScmException("Unable to list files in checkout directory", (Throwable)e);
        }
        this.getLogger().debug("checkout command end successfully ...");
        return new CheckOutScmResult(files, new ScmResult("multiple commandline", "OK", "OK", true));
    }
}

