/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.tag;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnTagCommand
extends AbstractTagCommand
implements SvnCommand {
    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, String message) throws ScmException {
        ScmTagParameters scmTagParameters = new ScmTagParameters(message);
        scmTagParameters.setRemoteTagging(false);
        return this.executeTagCommand(repo, fileSet, tag, scmTagParameters);
    }

    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        int exitCode;
        if (scmTagParameters == null) {
            this.getLogger().debug("SvnTagCommand :: scmTagParameters is null create an empty one");
            scmTagParameters = new ScmTagParameters();
            scmTagParameters.setRemoteTagging(false);
        } else {
            this.getLogger().debug("SvnTagCommand :: scmTagParameters.remoteTagging : " + scmTagParameters.isRemoteTagging());
        }
        if (tag == null || StringUtils.isEmpty((String)tag.trim())) {
            throw new ScmException("tag must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)(scmTagParameters == null ? "" : scmTagParameters.getMessage()));
        }
        catch (IOException ex) {
            return new TagScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        Commandline cl = SvnTagCommand.createCommandLine(repository, fileSet.getBasedir(), tag, messageFile, scmTagParameters);
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, stdout, stderr, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException ex) {}
        }
        if (exitCode != 0) {
            return new TagScmResult(cl.toString(), "The svn tag command failed.", stderr.getOutput(), false);
        }
        ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
        List files = null;
        try {
            List list;
            files = StringUtils.isNotEmpty((String)fileSet.getExcludes()) ? (list = FileUtils.getFiles((File)fileSet.getBasedir(), (String)(StringUtils.isEmpty((String)fileSet.getIncludes()) ? "**" : fileSet.getIncludes()), (String)(fileSet.getExcludes() + ",**/.svn/**"), (boolean)false)) : (list = FileUtils.getFiles((File)fileSet.getBasedir(), (String)(StringUtils.isEmpty((String)fileSet.getIncludes()) ? "**" : fileSet.getIncludes()), (String)"**/.svn/**", (boolean)false));
        }
        catch (IOException e) {
            throw new ScmException("Error while executing command.", (Throwable)e);
        }
        for (File f : files) {
            fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
        }
        return new TagScmResult(cl.toString(), fileList);
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String tag, File messageFile) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArg().setValue("copy");
        cl.createArg().setValue("--file");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        cl.createArg().setValue(".");
        String tagUrl = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag));
        cl.createArg().setValue(SvnCommandUtils.fixUrl((String)tagUrl, (String)repository.getUser()));
        return cl;
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String tag, File messageFile, ScmTagParameters scmTagParameters) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArg().setValue("copy");
        cl.createArg().setValue("--file");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        if (scmTagParameters != null && scmTagParameters.getScmRevision() != null) {
            cl.createArg().setValue("--revision");
            cl.createArg().setValue(scmTagParameters.getScmRevision());
        }
        if (scmTagParameters != null && scmTagParameters.isRemoteTagging()) {
            cl.createArg().setValue(repository.getUrl());
        } else {
            cl.createArg().setValue(".");
        }
        String tagUrl = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag));
        cl.createArg().setValue(SvnCommandUtils.fixUrl((String)tagUrl, (String)repository.getUser()));
        return cl;
    }
}

